/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.types;

import java.sql.SQLException;
import java.util.Map;
import org.opensearch.jdbc.types.TypeHelper;

public class DoubleType
implements TypeHelper<Double> {
    public static final DoubleType INSTANCE = new DoubleType();

    private DoubleType() {
    }

    @Override
    public Double fromValue(Object value, Map<String, Object> conversionParams) throws SQLException {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            return this.asDouble((String)value);
        }
        if (value instanceof Number) {
            return this.asDouble((Number)value);
        }
        throw this.objectConversionException(value);
    }

    private Double asDouble(String value) throws SQLException {
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException nfe) {
            throw this.stringConversionException(value, nfe);
        }
    }

    private Double asDouble(Number value) throws SQLException {
        return value.doubleValue();
    }

    @Override
    public String getTypeName() {
        return "Double";
    }
}

