/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.types;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opensearch.jdbc.types.BooleanType;
import org.opensearch.jdbc.types.ByteType;
import org.opensearch.jdbc.types.DateType;
import org.opensearch.jdbc.types.DoubleType;
import org.opensearch.jdbc.types.FloatType;
import org.opensearch.jdbc.types.IntegerType;
import org.opensearch.jdbc.types.LongType;
import org.opensearch.jdbc.types.ShortType;
import org.opensearch.jdbc.types.StringType;
import org.opensearch.jdbc.types.StructType;
import org.opensearch.jdbc.types.TimeType;
import org.opensearch.jdbc.types.TimestampType;
import org.opensearch.jdbc.types.TypeConverter;
import org.opensearch.jdbc.types.TypeHelper;

public abstract class BaseTypeConverter
implements TypeConverter {
    static final Map<Class, TypeHelper> typeHandlerMap = new HashMap<Class, TypeHelper>();

    @Override
    public <T> T convert(Object value, Class<T> clazz, Map<String, Object> conversionParams) throws SQLException {
        TypeHelper<T> typeHelper;
        if (clazz == null) {
            clazz = this.getDefaultJavaClass();
        }
        if (this.getSupportedJavaClasses() != null && this.getSupportedJavaClasses().contains(clazz) && (typeHelper = this.getTypeHelper(clazz)) != null) {
            return typeHelper.fromValue(value, conversionParams);
        }
        throw this.objectConversionException(value, clazz);
    }

    private <T> TypeHelper<T> getTypeHelper(Class<T> clazz) {
        return typeHandlerMap.get(clazz);
    }

    public abstract Class getDefaultJavaClass();

    public abstract Set<Class> getSupportedJavaClasses();

    static {
        typeHandlerMap.put(String.class, StringType.INSTANCE);
        typeHandlerMap.put(Byte.class, ByteType.INSTANCE);
        typeHandlerMap.put(Short.class, ShortType.INSTANCE);
        typeHandlerMap.put(Integer.class, IntegerType.INSTANCE);
        typeHandlerMap.put(Long.class, LongType.INSTANCE);
        typeHandlerMap.put(Float.class, FloatType.INSTANCE);
        typeHandlerMap.put(Double.class, DoubleType.INSTANCE);
        typeHandlerMap.put(Boolean.class, BooleanType.INSTANCE);
        typeHandlerMap.put(Timestamp.class, TimestampType.INSTANCE);
        typeHandlerMap.put(Date.class, DateType.INSTANCE);
        typeHandlerMap.put(Time.class, TimeType.INSTANCE);
        typeHandlerMap.put(Struct.class, StructType.INSTANCE);
    }
}

