/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.transport.http;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.Signer;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.opensearch.jdbc.auth.AuthenticationType;
import org.opensearch.jdbc.config.ConnectionConfig;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.logging.LoggingSource;
import org.opensearch.jdbc.transport.TransportException;
import org.opensearch.jdbc.transport.http.ApacheHttpClientConnectionFactory;
import org.opensearch.jdbc.transport.http.HttpParam;
import org.opensearch.jdbc.transport.http.HttpTransport;
import org.opensearch.jdbc.transport.http.JclLoggerAdapter;
import org.opensearch.jdbc.transport.http.auth.aws.AWSRequestSigningApacheInterceptor;

public class ApacheHttpTransport
implements HttpTransport,
LoggingSource {
    String scheme;
    String host;
    int port;
    String path;
    int readTimeout;
    private RequestConfig requestConfig;
    private CloseableHttpClient httpClient;

    public ApacheHttpTransport(ConnectionConfig connectionConfig, Logger log, String userAgent) throws TransportException {
        this.host = connectionConfig.getHost();
        this.port = connectionConfig.getPort();
        this.scheme = connectionConfig.isUseSSL() ? "https" : "http";
        this.path = connectionConfig.getPath();
        this.updateRequestConfig();
        ConnectionSocketFactory sslConnectionSocketFactory = null;
        try {
            sslConnectionSocketFactory = this.getSslConnectionSocketFactory(connectionConfig);
        }
        catch (Exception e) {
            throw new TransportException("Exception building SSL/TLS socket factory " + e, e);
        }
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslConnectionSocketFactory).build();
        ApacheHttpClientConnectionFactory connectionFactory = new ApacheHttpClientConnectionFactory(new JclLoggerAdapter(log, this.getSource()));
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)new BasicHttpClientConnectionManager((Lookup)socketFactoryRegistry, (HttpConnectionFactory)connectionFactory)).setDefaultSocketConfig(this.buildDefaultSocketConfig()).setDefaultRequestConfig(this.getRequestConfig()).setUserAgent(userAgent);
        if (!connectionConfig.requestCompression()) {
            httpClientBuilder.disableContentCompression();
        }
        if (connectionConfig.getAuthenticationType() == AuthenticationType.BASIC) {
            BasicCredentialsProvider basicCredsProvider = new BasicCredentialsProvider();
            basicCredsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(connectionConfig.getUser(), connectionConfig.getPassword()));
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)basicCredsProvider);
        } else if (connectionConfig.getAuthenticationType() == AuthenticationType.AWS_SIGV4) {
            AWS4Signer signer = new AWS4Signer();
            signer.setServiceName("es");
            signer.setRegionName(connectionConfig.getRegion());
            AWSCredentialsProvider provider = connectionConfig.getAwsCredentialsProvider() != null ? connectionConfig.getAwsCredentialsProvider() : new DefaultAWSCredentialsProviderChain();
            httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new AWSRequestSigningApacheInterceptor("es", (Signer)signer, provider));
        }
        this.httpClient = httpClientBuilder.build();
    }

    @Override
    public CloseableHttpResponse doGet(String path, Header[] headers, HttpParam[] params, int timeout) throws TransportException {
        return this.doGet(this.buildRequestURI(path, params), headers, timeout);
    }

    @Override
    public CloseableHttpResponse doPost(String path, Header[] headers, HttpParam[] params, String body, int timeout) throws TransportException {
        return this.doPost(this.buildRequestURI(path, params), headers, body, timeout);
    }

    @Override
    public void close() throws TransportException {
        try {
            this.httpClient.close();
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private ConnectionSocketFactory getSslConnectionSocketFactory(ConnectionConfig connectionConfig) throws CertificateException, NoSuchAlgorithmException, KeyStoreException, IOException, UnrecoverableKeyException, KeyManagementException {
        TrustSelfSignedStrategy trustStrategy = connectionConfig.trustSelfSigned() ? new TrustSelfSignedStrategy() : null;
        SSLContextBuilder builder = SSLContexts.custom();
        if (connectionConfig.getKeyStoreLocation() != null || connectionConfig.getTrustStoreLocation() != null) {
            char[] password;
            if (connectionConfig.getTrustStoreLocation() != null) {
                String trustStorePassword = connectionConfig.getTrustStorePassword();
                password = trustStorePassword == null ? "".toCharArray() : trustStorePassword.toCharArray();
                builder.loadTrustMaterial(new File(connectionConfig.getTrustStoreLocation()), password, (TrustStrategy)trustStrategy);
            }
            if (connectionConfig.getKeyStoreLocation() != null) {
                String keyStorePassword = connectionConfig.getKeyStorePassword();
                password = keyStorePassword == null ? "".toCharArray() : keyStorePassword.toCharArray();
                builder.loadKeyMaterial(new File(connectionConfig.getKeyStoreLocation()), password, password).build();
            }
        } else {
            builder.loadTrustMaterial(null, (TrustStrategy)trustStrategy);
        }
        HostnameVerifier hostnameVerifier = connectionConfig.hostnameVerification() ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : new NoopHostnameVerifier();
        SSLContext sslContext = builder.build();
        return new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
    }

    private SocketConfig buildDefaultSocketConfig() {
        return SocketConfig.custom().setSoKeepAlive(true).setSoTimeout(this.readTimeout).build();
    }

    private void updateRequestConfig() {
        this.requestConfig = RequestConfig.custom().setSocketTimeout(this.readTimeout).build();
    }

    private RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        if (readTimeout != this.readTimeout) {
            this.readTimeout = readTimeout;
            this.updateRequestConfig();
        }
    }

    private URIBuilder getUriBuilder(String path) {
        return new URIBuilder().setScheme(this.scheme).setHost(this.host).setPort(this.port).setPath(this.path + path);
    }

    private URI buildRequestURI(String path, HttpParam ... params) throws TransportException {
        try {
            URIBuilder uriBuilder = this.getUriBuilder(path);
            if (params != null) {
                for (HttpParam param : params) {
                    uriBuilder.setParameter(param.getName(), param.getValue());
                }
            }
            return uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new TransportException(e);
        }
    }

    private CloseableHttpResponse doGet(URI uri, Header[] headers, int readTimeout) throws TransportException {
        try {
            this.setReadTimeout(readTimeout);
            HttpGet request = new HttpGet(uri);
            request.setHeaders(headers);
            request.setConfig(this.getRequestConfig());
            return this.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }

    private CloseableHttpResponse doPost(URI uri, Header[] headers, String body, int readTimeout) throws TransportException {
        try {
            this.setReadTimeout(readTimeout);
            HttpPost request = new HttpPost(uri);
            request.setHeaders(headers);
            request.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
            request.setConfig(this.getRequestConfig());
            return this.httpClient.execute((HttpUriRequest)request);
        }
        catch (IOException e) {
            throw new TransportException(e);
        }
    }
}

