/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.protocol.http;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.opensearch.jdbc.OpenSearchVersion;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonOpenSearchVersion
implements OpenSearchVersion {
    private String fullVersion;
    private int[] version = new int[3];

    public JsonOpenSearchVersion(@JsonProperty(value="number") String fullVersion) {
        if (fullVersion == null) {
            return;
        }
        this.fullVersion = fullVersion;
        String[] versionTokens = fullVersion.split("[.-]");
        for (int i = 0; i < versionTokens.length && i < 3; ++i) {
            this.version[i] = this.parseNumber(versionTokens[i]);
        }
    }

    private int parseNumber(String str) {
        int number = 0;
        try {
            number = Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return number;
    }

    @Override
    public int getMajor() {
        return this.version[0];
    }

    @Override
    public int getMinor() {
        return this.version[1];
    }

    @Override
    public int getRevision() {
        return this.version[2];
    }

    @Override
    public String getFullVersion() {
        return this.fullVersion;
    }
}

