/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.protocol.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.opensearch.jdbc.protocol.exceptions.MalformedResponseException;
import org.opensearch.jdbc.protocol.exceptions.ResponseException;
import org.opensearch.jdbc.protocol.http.HttpException;
import org.opensearch.jdbc.protocol.http.JsonHttpProtocol;

public class JsonHttpResponseHandler {
    protected JsonHttpProtocol protocol;
    public static final Set<Integer> DEFAULT_ACCEPTABLE_HTTP_CODES = Collections.unmodifiableSet(new HashSet<Integer>(Arrays.asList(200)));

    public JsonHttpResponseHandler(JsonHttpProtocol protocol) {
        this.protocol = protocol;
    }

    public <R> R handleResponse(HttpResponse response, JsonContentParser<InputStream, R> contentParser) throws ResponseException {
        return this.handleResponse(response, null, true, contentParser);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R handleResponse(HttpResponse response, Set<Integer> acceptableHttpStatusCodes, boolean expectResponseBody, JsonContentParser<InputStream, R> contentParser) throws ResponseException {
        try {
            this.checkResponseForErrors(response, acceptableHttpStatusCodes, expectResponseBody);
            try (InputStream responseContent = response.getEntity().getContent();){
                R r = contentParser.apply(responseContent);
                return r;
            }
        }
        catch (JsonProcessingException jpe) {
            throw new MalformedResponseException("Could not process server response", jpe);
        }
        catch (IOException ioe) {
            throw new ResponseException("Error reading server response", ioe);
        }
    }

    protected void checkResponseForErrors(HttpResponse response, Set<Integer> acceptableHttpStatusCodes, boolean expectResponseBodyContent) throws ResponseException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (!this.isHttpStatusCodeAcceptable(statusCode, acceptableHttpStatusCodes)) {
            String responseBody = this.extractResponseBody(response);
            HttpException httpException = new HttpException(statusCode, response.getStatusLine().getReasonPhrase(), null, responseBody);
            if (statusCode == 405) {
                throw new ResponseException("Could not submit SQL request to the target server. Make sure the SQL plugin is installed on the server and responding on the \"/" + this.protocol.getSqlContextPath() + "\" context path.", httpException);
            }
            throw httpException;
        }
        if (expectResponseBodyContent && (response.getEntity() == null || response.getEntity().getContent() == null)) {
            throw new MalformedResponseException("Empty response.");
        }
    }

    protected String extractResponseBody(HttpResponse response) {
        String responseBody = null;
        try {
            if (response.getEntity() != null && response.getEntity().getContent() != null && response.getEntity().getContentType() != null && response.getEntity().getContentType().getValue() != null && (response.getEntity().getContentType().getValue().contains("application/json") || response.getEntity().getContentType().getValue().contains("text/plain"))) {
                responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return responseBody;
    }

    protected Set<Integer> getAcceptableHttpStatusCodes() {
        return DEFAULT_ACCEPTABLE_HTTP_CODES;
    }

    private boolean isHttpStatusCodeAcceptable(int statusCode, Set<Integer> acceptableHttpStatusCodes) {
        if (acceptableHttpStatusCodes == null) {
            acceptableHttpStatusCodes = DEFAULT_ACCEPTABLE_HTTP_CODES;
        }
        return acceptableHttpStatusCodes.contains(statusCode);
    }

    @FunctionalInterface
    public static interface JsonContentParser<T, R> {
        public R apply(T var1) throws IOException;
    }
}

