/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.logging;

import java.util.function.Supplier;
import org.opensearch.jdbc.logging.LogLevel;

public interface Logger {
    public LogLevel getLevel();

    public void fatal(String var1);

    public void fatal(String var1, Throwable var2);

    default public void fatal(Supplier<String> messageSupplier) {
        if (this.isFatalEnabled()) {
            this.fatal(messageSupplier.get());
        }
    }

    default public void fatal(Supplier<String> messageSupplier, Throwable t) {
        if (this.isFatalEnabled()) {
            this.fatal(messageSupplier.get(), t);
        }
    }

    public void error(String var1);

    public void error(String var1, Throwable var2);

    default public void error(Supplier<String> messageSupplier) {
        if (this.isErrorEnabled()) {
            this.error(messageSupplier.get());
        }
    }

    default public void error(Supplier<String> messageSupplier, Throwable t) {
        if (this.isErrorEnabled()) {
            this.error(messageSupplier.get(), t);
        }
    }

    public void warn(String var1);

    public void warn(String var1, Throwable var2);

    default public void warn(Supplier<String> messageSupplier) {
        if (this.isWarnEnabled()) {
            this.warn(messageSupplier.get());
        }
    }

    default public void warn(Supplier<String> messageSupplier, Throwable t) {
        if (this.isWarnEnabled()) {
            this.warn(messageSupplier.get(), t);
        }
    }

    public void info(String var1);

    public void info(String var1, Throwable var2);

    default public void info(Supplier<String> messageSupplier) {
        if (this.isInfoEnabled()) {
            this.info(messageSupplier.get());
        }
    }

    default public void info(Supplier<String> messageSupplier, Throwable t) {
        if (this.isInfoEnabled()) {
            this.info(messageSupplier.get(), t);
        }
    }

    public void debug(String var1);

    public void debug(String var1, Throwable var2);

    default public void debug(Supplier<String> messageSupplier) {
        if (this.isDebugEnabled()) {
            this.debug(messageSupplier.get());
        }
    }

    default public void debug(Supplier<String> messageSupplier, Throwable t) {
        if (this.isDebugEnabled()) {
            this.debug(messageSupplier.get(), t);
        }
    }

    public void trace(String var1);

    public void trace(String var1, Throwable var2);

    default public void trace(Supplier<String> messageSupplier) {
        if (this.isTraceEnabled()) {
            this.trace(messageSupplier.get());
        }
    }

    default public void trace(Supplier<String> messageSupplier, Throwable t) {
        if (this.isTraceEnabled()) {
            this.trace(messageSupplier.get(), t);
        }
    }

    default public boolean isDebugEnabled() {
        return this.getLevel().isGreaterThanOrEqualTo(LogLevel.DEBUG);
    }

    default public boolean isErrorEnabled() {
        return this.isLevelEnabled(LogLevel.ERROR);
    }

    default public boolean isFatalEnabled() {
        return this.isLevelEnabled(LogLevel.FATAL);
    }

    default public boolean isInfoEnabled() {
        return this.isLevelEnabled(LogLevel.INFO);
    }

    default public boolean isTraceEnabled() {
        return this.isLevelEnabled(LogLevel.TRACE);
    }

    default public boolean isWarnEnabled() {
        return this.isLevelEnabled(LogLevel.WARN);
    }

    default public boolean isLevelEnabled(LogLevel level) {
        return this.getLevel().isGreaterThanOrEqualTo(level);
    }

    public void close();
}

