/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.internal.results;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.jdbc.internal.results.ColumnMetaData;
import org.opensearch.jdbc.internal.results.Row;
import org.opensearch.jdbc.internal.results.Schema;

public class Cursor {
    private Schema schema;
    private List<Row> rows;
    private int currentRow = -1;
    private Map<String, Integer> labelToIndexMap;

    public Cursor(Schema schema, List<Row> rows) {
        this.schema = schema;
        this.rows = rows;
        this.initLabelToIndexMap();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Object getColumn(int index) {
        if (index < 0 || index >= this.getColumnCount()) {
            throw new IllegalArgumentException("Column Index out of range: " + index);
        }
        return this.rows.get(this.currentRow).get(index);
    }

    public int getColumnCount() {
        return this.schema.getNumberOfColumns();
    }

    public boolean next() {
        if (this.currentRow < this.rows.size() - 1) {
            ++this.currentRow;
            return true;
        }
        return false;
    }

    public Integer findColumn(String label) {
        return this.labelToIndexMap.get(label);
    }

    private void initLabelToIndexMap() {
        this.labelToIndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < this.schema.getNumberOfColumns(); ++i) {
            ColumnMetaData columnMetaData = this.schema.getColumnMetaData(i);
            this.labelToIndexMap.put(columnMetaData.getLabel(), i);
        }
    }
}

