/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.config;

import org.opensearch.jdbc.config.ConnectionProperty;
import org.opensearch.jdbc.config.ConnectionPropertyException;

public class IntConnectionProperty
extends ConnectionProperty<Integer> {
    public IntConnectionProperty(String key) {
        super(key);
    }

    @Override
    protected Integer parseValue(Object value) throws ConnectionPropertyException {
        if (value == null) {
            return this.getDefault();
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ConnectionPropertyException(this.getKey(), String.format("Property %s requires a valid integer. Invalid property value %s. ", this.getKey(), value));
    }

    @Override
    public Integer getDefault() {
        return 0;
    }
}

