/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc.config;

import com.amazonaws.auth.AWSCredentialsProvider;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.opensearch.jdbc.auth.AuthenticationType;
import org.opensearch.jdbc.config.AuthConnectionProperty;
import org.opensearch.jdbc.config.AwsCredentialsProviderProperty;
import org.opensearch.jdbc.config.ConnectionProperty;
import org.opensearch.jdbc.config.ConnectionPropertyException;
import org.opensearch.jdbc.config.FetchSizeProperty;
import org.opensearch.jdbc.config.HostConnectionProperty;
import org.opensearch.jdbc.config.HostnameVerificationConnectionProperty;
import org.opensearch.jdbc.config.KeyStoreLocationConnectionProperty;
import org.opensearch.jdbc.config.KeyStorePasswordConnectionProperty;
import org.opensearch.jdbc.config.KeyStoreTypeConnectionProperty;
import org.opensearch.jdbc.config.LogLevelConnectionProperty;
import org.opensearch.jdbc.config.LogOutputConnectionProperty;
import org.opensearch.jdbc.config.LoginTimeoutConnectionProperty;
import org.opensearch.jdbc.config.PasswordConnectionProperty;
import org.opensearch.jdbc.config.PathConnectionProperty;
import org.opensearch.jdbc.config.PortConnectionProperty;
import org.opensearch.jdbc.config.RegionConnectionProperty;
import org.opensearch.jdbc.config.RequestCompressionConnectionProperty;
import org.opensearch.jdbc.config.TrustSelfSignedConnectionProperty;
import org.opensearch.jdbc.config.TrustStoreLocationConnectionProperty;
import org.opensearch.jdbc.config.TrustStorePasswordConnectionProperty;
import org.opensearch.jdbc.config.TrustStoreTypeConnectionProperty;
import org.opensearch.jdbc.config.UseSSLConnectionProperty;
import org.opensearch.jdbc.config.UserConnectionProperty;
import org.opensearch.jdbc.internal.util.AwsHostNameUtil;
import org.opensearch.jdbc.internal.util.UrlParser;
import org.opensearch.jdbc.logging.LogLevel;

public class ConnectionConfig {
    private String url;
    private String host;
    private int port;
    private int fetchSize;
    private String path;
    private boolean useSSL;
    private int loginTimeout;
    private String logOutput;
    private PrintWriter logWriter;
    private String user;
    private String password;
    private boolean requestCompression;
    private AuthenticationType authenticationType;
    private AWSCredentialsProvider awsCredentialsProvider;
    private String region;
    private LogLevel logLevel;
    private String keyStoreLocation;
    private String keyStorePassword;
    private String keyStoreType;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String trustStoreType;
    private boolean trustSelfSigned;
    private boolean hostnameVerification;

    private ConnectionConfig(Builder builder) {
        this.url = builder.getUrl();
        this.host = (String)builder.getHostProperty().getValue();
        this.port = (Integer)builder.getPortProperty().getValue();
        this.fetchSize = (Integer)builder.getFetchSizeProperty().getValue();
        this.path = (String)builder.getPathProperty().getValue();
        this.useSSL = (Boolean)builder.getUseSSLProperty().getValue();
        this.logOutput = (String)builder.getLogOutputProperty().getValue();
        this.logLevel = (LogLevel)((Object)builder.getLogLevelConnectionProperty().getValue());
        this.logWriter = builder.getLogWriter();
        this.loginTimeout = (Integer)builder.getLoginTimeoutProperty().getValue();
        this.user = (String)builder.getUserProperty().getValue();
        this.password = (String)builder.getPasswordProperty().getValue();
        this.requestCompression = (Boolean)builder.getRequestCompressionProperty().getValue();
        this.authenticationType = (AuthenticationType)((Object)builder.getAuthConnectionProperty().getValue());
        this.awsCredentialsProvider = (AWSCredentialsProvider)builder.getAwsCredentialProvider().getValue();
        this.region = (String)builder.getRegionConnectionProperty().getValue();
        this.keyStoreLocation = (String)builder.getKeyStoreLocationConnectionProperty().getValue();
        this.keyStorePassword = (String)builder.getKeyStorePasswordConnectionProperty().getValue();
        this.keyStoreType = (String)builder.getKeyStoreTypeConnectionProperty().getValue();
        this.trustStoreLocation = (String)builder.getTrustStoreLocationConnectionProperty().getValue();
        this.trustStorePassword = (String)builder.getTrustStorePasswordConnectionProperty().getValue();
        this.trustStoreType = (String)builder.getTrustStoreTypeConnectionProperty().getValue();
        this.trustSelfSigned = (Boolean)builder.getTrustSelfSignedConnectionProperty().getValue();
        this.hostnameVerification = (Boolean)builder.getHostnameVerificationConnectionProperty().getValue();
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUrl() {
        return this.url;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public boolean requestCompression() {
        return this.requestCompression;
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public String getLogOutput() {
        return this.logOutput;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public AWSCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    public String getRegion() {
        return this.region;
    }

    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public boolean trustSelfSigned() {
        return this.trustSelfSigned;
    }

    public boolean hostnameVerification() {
        return this.hostnameVerification;
    }

    public String toString() {
        return "ConnectionConfig{url='" + this.url + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + ", fetchSize=" + this.fetchSize + ", path='" + this.path + '\'' + ", useSSL=" + this.useSSL + ", loginTimeout=" + this.loginTimeout + ", logOutput='" + this.logOutput + '\'' + ", logWriter=" + this.logWriter + ", user='" + this.user + '\'' + ", password='" + this.mask(this.password) + '\'' + ", requestCompression=" + this.requestCompression + ", authenticationType=" + (Object)((Object)this.authenticationType) + ", awsCredentialsProvider=" + this.awsCredentialsProvider + ", region='" + this.region + '\'' + ", logLevel=" + (Object)((Object)this.logLevel) + ", keyStoreLocation='" + this.keyStoreLocation + '\'' + ", keyStorePassword='" + this.mask(this.keyStorePassword) + '\'' + ", keyStoreType='" + this.keyStoreType + '\'' + ", trustStoreLocation='" + this.trustStoreLocation + '\'' + ", trustStorePassword='" + this.mask(this.trustStorePassword) + '\'' + ", trustStoreType='" + this.trustStoreType + '\'' + ", trustSelfSigned='" + this.trustSelfSigned + '\'' + ", hostnameVerification='" + this.hostnameVerification + '\'' + '}';
    }

    private String mask(String string) {
        return string == null || string.length() == 0 ? "<not set>" : "<set>";
    }

    public static class Builder {
        private HostConnectionProperty hostProperty = new HostConnectionProperty();
        private PortConnectionProperty portProperty = new PortConnectionProperty();
        private FetchSizeProperty fetchSizeProperty = new FetchSizeProperty();
        private LoginTimeoutConnectionProperty loginTimeoutProperty = new LoginTimeoutConnectionProperty();
        private UseSSLConnectionProperty useSSLProperty = new UseSSLConnectionProperty();
        private PathConnectionProperty pathProperty = new PathConnectionProperty();
        private LogOutputConnectionProperty logOutputProperty = new LogOutputConnectionProperty();
        private UserConnectionProperty userProperty = new UserConnectionProperty();
        private PasswordConnectionProperty passwordProperty = new PasswordConnectionProperty();
        private RequestCompressionConnectionProperty requestCompressionProperty = new RequestCompressionConnectionProperty();
        private AuthConnectionProperty authConnectionProperty = new AuthConnectionProperty();
        private RegionConnectionProperty regionConnectionProperty = new RegionConnectionProperty();
        private LogLevelConnectionProperty logLevelConnectionProperty = new LogLevelConnectionProperty();
        private KeyStoreLocationConnectionProperty keyStoreLocationConnectionProperty = new KeyStoreLocationConnectionProperty();
        private KeyStorePasswordConnectionProperty keyStorePasswordConnectionProperty = new KeyStorePasswordConnectionProperty();
        private KeyStoreTypeConnectionProperty keyStoreTypeConnectionProperty = new KeyStoreTypeConnectionProperty();
        private TrustStoreLocationConnectionProperty trustStoreLocationConnectionProperty = new TrustStoreLocationConnectionProperty();
        private TrustStorePasswordConnectionProperty trustStorePasswordConnectionProperty = new TrustStorePasswordConnectionProperty();
        private TrustStoreTypeConnectionProperty trustStoreTypeConnectionProperty = new TrustStoreTypeConnectionProperty();
        private TrustSelfSignedConnectionProperty trustSelfSignedConnectionProperty = new TrustSelfSignedConnectionProperty();
        private AwsCredentialsProviderProperty awsCredentialsProviderProperty = new AwsCredentialsProviderProperty();
        private HostnameVerificationConnectionProperty hostnameVerificationConnectionProperty = new HostnameVerificationConnectionProperty();
        ConnectionProperty[] connectionProperties = new ConnectionProperty[]{this.hostProperty, this.portProperty, this.fetchSizeProperty, this.loginTimeoutProperty, this.useSSLProperty, this.pathProperty, this.logOutputProperty, this.logLevelConnectionProperty, this.userProperty, this.passwordProperty, this.requestCompressionProperty, this.authConnectionProperty, this.awsCredentialsProviderProperty, this.regionConnectionProperty, this.keyStoreLocationConnectionProperty, this.keyStorePasswordConnectionProperty, this.keyStoreTypeConnectionProperty, this.trustStoreLocationConnectionProperty, this.trustStorePasswordConnectionProperty, this.trustStoreTypeConnectionProperty, this.trustSelfSignedConnectionProperty, this.hostnameVerificationConnectionProperty};
        private String url = null;
        private PrintWriter logWriter = null;
        private Map<String, Object> propertyMap;
        private Map<String, Object> overrideMap;
        private Properties urlProperties;
        private Properties properties;

        public ConnectionProperty[] getConnectionProperties() {
            return this.connectionProperties;
        }

        public HostConnectionProperty getHostProperty() {
            return this.hostProperty;
        }

        public PortConnectionProperty getPortProperty() {
            return this.portProperty;
        }

        public FetchSizeProperty getFetchSizeProperty() {
            return this.fetchSizeProperty;
        }

        public LoginTimeoutConnectionProperty getLoginTimeoutProperty() {
            return this.loginTimeoutProperty;
        }

        public UseSSLConnectionProperty getUseSSLProperty() {
            return this.useSSLProperty;
        }

        public PathConnectionProperty getPathProperty() {
            return this.pathProperty;
        }

        public LogOutputConnectionProperty getLogOutputProperty() {
            return this.logOutputProperty;
        }

        public UserConnectionProperty getUserProperty() {
            return this.userProperty;
        }

        public PasswordConnectionProperty getPasswordProperty() {
            return this.passwordProperty;
        }

        public RequestCompressionConnectionProperty getRequestCompressionProperty() {
            return this.requestCompressionProperty;
        }

        public AuthConnectionProperty getAuthConnectionProperty() {
            return this.authConnectionProperty;
        }

        public AwsCredentialsProviderProperty getAwsCredentialProvider() {
            return this.awsCredentialsProviderProperty;
        }

        public RegionConnectionProperty getRegionConnectionProperty() {
            return this.regionConnectionProperty;
        }

        public LogLevelConnectionProperty getLogLevelConnectionProperty() {
            return this.logLevelConnectionProperty;
        }

        public PrintWriter getLogWriter() {
            return this.logWriter;
        }

        public KeyStoreLocationConnectionProperty getKeyStoreLocationConnectionProperty() {
            return this.keyStoreLocationConnectionProperty;
        }

        public KeyStorePasswordConnectionProperty getKeyStorePasswordConnectionProperty() {
            return this.keyStorePasswordConnectionProperty;
        }

        public KeyStoreTypeConnectionProperty getKeyStoreTypeConnectionProperty() {
            return this.keyStoreTypeConnectionProperty;
        }

        public TrustStoreLocationConnectionProperty getTrustStoreLocationConnectionProperty() {
            return this.trustStoreLocationConnectionProperty;
        }

        public TrustStorePasswordConnectionProperty getTrustStorePasswordConnectionProperty() {
            return this.trustStorePasswordConnectionProperty;
        }

        public TrustStoreTypeConnectionProperty getTrustStoreTypeConnectionProperty() {
            return this.trustStoreTypeConnectionProperty;
        }

        public TrustSelfSignedConnectionProperty getTrustSelfSignedConnectionProperty() {
            return this.trustSelfSignedConnectionProperty;
        }

        public HostnameVerificationConnectionProperty getHostnameVerificationConnectionProperty() {
            return this.hostnameVerificationConnectionProperty;
        }

        public Builder setLogWriter(PrintWriter printWriter) {
            this.logWriter = printWriter;
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setPropertyMap(Map<String, Object> map) {
            if (map != null) {
                this.propertyMap = new HashMap<String, Object>();
                this.propertyMap.putAll(map);
            }
            return this;
        }

        public Builder overrideProperties(Map<String, Object> map) {
            if (map != null) {
                if (this.overrideMap == null) {
                    this.overrideMap = new HashMap<String, Object>();
                }
                this.overrideMap.putAll(map);
            }
            return this;
        }

        public Builder setProperties(Properties properties) {
            if (properties != null) {
                this.properties = new Properties();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    this.properties.setProperty(key, properties.getProperty(key));
                }
            }
            return this;
        }

        public ConnectionConfig build() throws ConnectionPropertyException {
            if (this.url != null) {
                try {
                    this.urlProperties = UrlParser.parseProperties(this.url);
                }
                catch (URISyntaxException e) {
                    throw new ConnectionPropertyException("Invalid connection URL", e);
                }
            }
            for (ConnectionProperty connectionProperty : this.connectionProperties) {
                this.setRawValue(connectionProperty);
            }
            this.validateConfig();
            return new ConnectionConfig(this);
        }

        private void setRawValue(ConnectionProperty connectionProperty) throws ConnectionPropertyException {
            Object value = this.getPropertyValueToSet(connectionProperty.getKey());
            connectionProperty.setRawValue(value);
        }

        private void validateConfig() throws ConnectionPropertyException {
            AuthenticationType authenticationType = (AuthenticationType)((Object)this.authConnectionProperty.getValue());
            if (authenticationType == AuthenticationType.NONE) {
                if (this.userProperty.getValue() != null) {
                    this.authConnectionProperty.setRawValue(AuthenticationType.BASIC.name());
                }
            } else {
                if (authenticationType == AuthenticationType.BASIC && this.userProperty.getValue() == null) {
                    throw new ConnectionPropertyException(this.authConnectionProperty.getKey(), "Basic authentication requires a valid username but none was provided.");
                }
                if (authenticationType == AuthenticationType.AWS_SIGV4 && this.regionConnectionProperty.getValue() == null) {
                    String region = AwsHostNameUtil.parseRegion((String)this.hostProperty.getValue());
                    if (region == null) {
                        throw new ConnectionPropertyException(this.authConnectionProperty.getKey(), String.format("AWS Signature V4 authentication requires a region to be used, but a valid value could not be determined from the specified hostname. Provide an explicit region value (e.g. us-east-1) via the \"%s\" connection property.", this.regionConnectionProperty.getKey()));
                    }
                    this.regionConnectionProperty.setRawValue(region);
                }
            }
            if (this.portProperty.getRawValue() == null && ((Boolean)this.useSSLProperty.getValue()).booleanValue()) {
                this.portProperty.setRawValue(443);
            }
            if ((Integer)this.fetchSizeProperty.getValue() < 0) {
                throw new ConnectionPropertyException(this.fetchSizeProperty.getKey(), "Cursor fetch size value should be greater or equal to zero");
            }
        }

        private Object getPropertyValueToSet(String key) {
            String value;
            if (this.overrideMap != null && this.overrideMap.containsKey(key)) {
                return this.overrideMap.get(key);
            }
            if (this.propertyMap != null && this.propertyMap.containsKey(key)) {
                return this.propertyMap.get(key);
            }
            if (this.properties != null && (value = this.properties.getProperty(key)) != null) {
                return value;
            }
            if (this.urlProperties != null && (value = this.urlProperties.getProperty(key)) != null) {
                return value;
            }
            return null;
        }
    }
}

