/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.JDBCType;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLNonTransientException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.jdbc.ConnectionImpl;
import org.opensearch.jdbc.StatementImpl;
import org.opensearch.jdbc.internal.util.SqlParser;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.protocol.JdbcDateTimeFormatter;
import org.opensearch.jdbc.protocol.JdbcQueryParam;
import org.opensearch.jdbc.protocol.JdbcQueryRequest;
import org.opensearch.jdbc.types.OpenSearchType;
import org.opensearch.jdbc.types.TypeConverters;

public class PreparedStatementImpl
extends StatementImpl
implements PreparedStatement {
    protected String sql;
    private JdbcQueryParam[] parameters;

    public PreparedStatementImpl(ConnectionImpl connection, String sql, Logger log) throws SQLException {
        super(connection, log);
        this.sql = sql;
        try {
            this.parameters = new JdbcQueryParam[SqlParser.countParameterMarkers(sql)];
        }
        catch (IllegalArgumentException iae) {
            this.logAndThrowSQLException(log, new SQLNonTransientException("Error preparing SQL statement: " + iae.getMessage(), iae));
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.log.debug(() -> this.logEntry("executeQuery()", new Object[0]));
        this.checkOpen();
        ResultSet rs = this.executeQueryX(this.getFetchSize());
        this.log.debug(() -> this.logExit("executeQuery", rs));
        return rs;
    }

    protected ResultSet executeQueryX(int fetchSize) throws SQLException {
        this.checkParamsFilled();
        JdbcQueryRequest jdbcQueryRequest = new JdbcQueryRequest(this.sql, fetchSize);
        jdbcQueryRequest.setParameters(Arrays.asList(this.parameters));
        return this.executeQueryRequest(jdbcQueryRequest);
    }

    @Override
    public int executeUpdate() throws SQLException {
        throw new SQLFeatureNotSupportedException("Updates are not supported");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.log.debug(() -> this.logEntry("setNull(%d, %d)", parameterIndex, sqlType));
        this.checkOpen();
        this.setParameter(parameterIndex, OpenSearchType.fromJdbcType(JDBCType.valueOf(sqlType)).getTypeName(), null);
        this.log.debug(() -> this.logExit("setNull"));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.log.debug(() -> this.logEntry("setBoolean(%d, %s)", parameterIndex, x));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, 16);
        this.log.debug(() -> this.logExit("setBoolean"));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.log.debug(() -> this.logEntry("setByte(%d, %d)", parameterIndex, x));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, -6);
        this.log.debug(() -> this.logExit("setByte"));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.log.debug(() -> this.logEntry("setShort(%d, %d)", parameterIndex, x));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, 5);
        this.log.debug(() -> this.logExit("setShort"));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.log.debug(() -> this.logEntry("setInt(%d, %d)", parameterIndex, x));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, 4);
        this.log.debug(() -> this.logExit("setInt"));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.log.debug(() -> this.logEntry("setLong(%d, %d)", parameterIndex, x));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, -5);
        this.log.debug(() -> this.logExit("setLong"));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.log.debug(() -> this.logEntry("setFloat(%d, %f)", parameterIndex, Float.valueOf(x)));
        this.checkOpen();
        this.setObjectX(parameterIndex, Float.valueOf(x), 7);
        this.log.debug(() -> this.logExit("setFloat"));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.log.debug(() -> this.logEntry("setDouble(%d, %f)", parameterIndex, x));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, 8);
        this.log.debug(() -> this.logExit("setDouble"));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("BigDecimal is not supported");
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.log.debug(() -> this.logEntry("setString(%d, %s)", parameterIndex, x));
        this.checkOpen();
        this.setParameter(parameterIndex, OpenSearchType.fromJdbcType(JDBCType.VARCHAR).getTypeName(), x);
        this.log.debug(() -> this.logExit("setString"));
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Setting byte arrays is not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.log.debug(() -> this.logEntry("setDate(%d, %s)", parameterIndex, x));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, 91);
        this.log.debug(() -> this.logExit("setDate"));
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Setting Time is not supported");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.log.debug(() -> this.logEntry("setTimestamp(%d, %s)", parameterIndex, x));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, 93);
        this.log.debug(() -> this.logExit("setTimestamp"));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Setting ASCII Stream is not supported");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Setting Unicode Stream is not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Setting Binary Stream is not supported");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.log.debug(() -> this.logEntry("clearParameters()", new Object[0]));
        for (int i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = null;
        }
        this.log.debug(() -> this.logExit("clearParameters"));
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.log.debug(() -> this.logEntry("setObject(%d, %s, %d)", parameterIndex, x, targetSqlType));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, targetSqlType, null);
        this.log.debug(() -> this.logExit("setObject"));
    }

    private void setObjectX(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObjectX(parameterIndex, x, targetSqlType, null);
    }

    private void setObjectX(int parameterIndex, Object x, int targetSqlType, Map<String, Object> conversionParams) throws SQLException {
        JDBCType jdbcType = JDBCType.valueOf(targetSqlType);
        OpenSearchType openSearchType = OpenSearchType.fromJdbcType(jdbcType);
        Object value = TypeConverters.getInstance(jdbcType).convert(x, null, conversionParams);
        if (jdbcType == JDBCType.TIMESTAMP) {
            value = JdbcDateTimeFormatter.JDBC_FORMAT.format((Timestamp)value);
        } else if (jdbcType == JDBCType.DATE) {
            value = JdbcDateTimeFormatter.JDBC_FORMAT.format((Date)value);
        }
        this.setParameter(parameterIndex, openSearchType.getTypeName(), value);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.log.debug(() -> this.logEntry("setObject(%d, %s)", parameterIndex, x));
        this.checkOpen();
        this.setObjectX(parameterIndex, x, this.javaToSqlType(x));
        this.log.debug(() -> this.logExit("setObject"));
    }

    private JDBCType javaToJDBCType(Object x) throws SQLException {
        if (x instanceof String) {
            return JDBCType.VARCHAR;
        }
        if (x instanceof Boolean) {
            return JDBCType.BOOLEAN;
        }
        if (x instanceof Byte) {
            return JDBCType.TINYINT;
        }
        if (x instanceof Short) {
            return JDBCType.SMALLINT;
        }
        if (x instanceof Integer) {
            return JDBCType.INTEGER;
        }
        if (x instanceof Long) {
            return JDBCType.BIGINT;
        }
        if (x instanceof Float) {
            return JDBCType.REAL;
        }
        if (x instanceof Double) {
            return JDBCType.DOUBLE;
        }
        if (x instanceof byte[]) {
            return JDBCType.VARBINARY;
        }
        if (x instanceof Date) {
            return JDBCType.DATE;
        }
        if (x instanceof Timestamp) {
            return JDBCType.TIMESTAMP;
        }
        throw new SQLDataException("Objects of type " + x.getClass().getName() + " not supported.");
    }

    private int javaToSqlType(Object x) throws SQLException {
        return this.javaToJDBCType(x).getVendorTypeNumber();
    }

    @Override
    public boolean execute() throws SQLException {
        this.log.debug(() -> this.logEntry("execute()", new Object[0]));
        this.checkOpen();
        this.executeQueryX(this.getFetchSize());
        this.log.debug(() -> this.logExit("execute", true));
        return true;
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("addBatch is not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream is not supported");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRef is not supported");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob is not supported");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob is not supported");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setArray is not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.log.debug(() -> this.logEntry("getMetaData ()", new Object[0]));
        ResultSetMetaData rsmd = this.resultSet != null ? this.resultSet.getMetaData() : null;
        this.log.debug(() -> this.logExit("getMetaData", rsmd));
        return rsmd;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.log.debug(() -> this.logEntry("setDate (%d, %s, %s)", parameterIndex, x, cal == null ? "null" : "Calendar TZ= " + cal.getTimeZone()));
        this.checkOpen();
        HashMap<String, Object> conversionParams = new HashMap<String, Object>();
        conversionParams.put("calendar", cal);
        this.setObjectX(parameterIndex, x, 91, conversionParams);
        this.log.debug(() -> this.logExit("setDate"));
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.log.debug(() -> this.logEntry("setTimestamp (%d, %s, %s)", parameterIndex, x, cal == null ? "null" : "Calendar TZ= " + cal.getTimeZone()));
        this.checkOpen();
        HashMap<String, Object> conversionParams = new HashMap<String, Object>();
        conversionParams.put("calendar", cal);
        this.setObjectX(parameterIndex, x, 93, conversionParams);
        this.log.debug(() -> this.logExit("setTimestamp"));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setURL not supported");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRowId not supported");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNString not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterStream not supported");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob not supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob not supported");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSQLXML not supported");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.setObjectX(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream not supported");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream not supported");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream not supported");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterStream not supported");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob not supported");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob not supported");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob not supported");
    }

    private void checkParamsFilled() throws SQLException {
        int filled = 0;
        for (int i = 0; i < this.parameters.length; ++i) {
            if (this.parameters[i] == null) continue;
            ++filled;
        }
        if (filled < this.parameters.length) {
            this.logAndThrowSQLException(this.log, new SQLDataException(String.format("Missing parameter values. The PreparedStatement requires %d parameter values but only %d were found.", this.parameters.length, filled)));
        }
    }

    protected void setParameter(int index, String type, Object value) throws SQLException {
        this.checkParamIndex(index);
        this.parameters[index - 1] = new JdbcQueryParam(type, value);
    }

    private void checkParamIndex(int index) throws SQLException {
        if (this.parameters == null || index < 1 || index > this.parameters.length) {
            this.logAndThrowSQLException(this.log, new SQLDataException("Invalid parameter index " + index));
        }
    }
}

