/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jdbc;

import com.amazonaws.auth.AWSCredentialsProvider;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.opensearch.jdbc.ConnectionImpl;
import org.opensearch.jdbc.Driver;
import org.opensearch.jdbc.config.ConnectionConfig;
import org.opensearch.jdbc.config.LoginTimeoutConnectionProperty;
import org.opensearch.jdbc.internal.JdbcWrapper;
import org.opensearch.jdbc.internal.util.UrlParser;
import org.opensearch.jdbc.logging.Logger;
import org.opensearch.jdbc.logging.LoggingSource;

public class OpenSearchDataSource
implements DataSource,
JdbcWrapper,
LoggingSource {
    private String url;
    private Map<String, Object> connectionProperties = new HashMap<String, Object>();
    private PrintWriter logWriter;

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        HashMap<String, Object> overrideProperties = new HashMap<String, Object>();
        overrideProperties.put("user", username);
        overrideProperties.put("password", password);
        return this.getConnection(overrideProperties);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        LoginTimeoutConnectionProperty property = new LoginTimeoutConnectionProperty();
        property.setRawValue(seconds);
        this.connectionProperties.put("loginTimeout", property.getValue());
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return (Integer)this.getConnectionProperty("loginTimeout", -1);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("DataSource does not use java.util.logging");
    }

    public void setUrl(String url) throws SQLException {
        this.url = url;
        try {
            UrlParser.parseProperties(url);
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid connection URL", e);
        }
    }

    public void setAwsCredentialProvider(AWSCredentialsProvider awsCredentialProvider) {
        this.connectionProperties.put("awsCredentialsProvider", awsCredentialProvider);
    }

    public void setProperties(Properties properties) throws SQLException {
        this.connectionProperties.clear();
        if (properties != null) {
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                this.connectionProperties.put(propertyName, properties.getProperty(propertyName));
            }
        }
    }

    public String getUrl() throws SQLException {
        return this.url;
    }

    private Object getConnectionProperty(String key, Object defaultValue) {
        return this.connectionProperties.getOrDefault(key, defaultValue);
    }

    private Connection getConnection(Map<String, Object> overrideProperties) throws SQLException {
        ConnectionConfig connectionConfig = this.getConnectionConfig(overrideProperties);
        Logger log = Driver.initLog(connectionConfig);
        log.debug(() -> this.logMessage("Opening connection using config: %s", connectionConfig));
        return new ConnectionImpl(connectionConfig, log);
    }

    ConnectionConfig getConnectionConfig(Map<String, Object> overrideProperties) throws SQLException {
        return ConnectionConfig.builder().setUrl(this.url).setPropertyMap(this.connectionProperties).setLogWriter(this.logWriter).overrideProperties(overrideProperties).build();
    }
}

