/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.example.customsuggester;

import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import org.opensearch.common.ParsingException;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.lucene.BytesRefs;
import org.opensearch.core.ParseField;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.example.customsuggester.CustomSuggestionContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.suggest.SuggestionBuilder;
import org.opensearch.search.suggest.SuggestionSearchContext;

public class CustomSuggestionBuilder
extends SuggestionBuilder<CustomSuggestionBuilder> {
    public static final String SUGGESTION_NAME = "custom";
    protected static final ParseField RANDOM_SUFFIX_FIELD = new ParseField("suffix", new String[0]);
    private String randomSuffix;

    public CustomSuggestionBuilder(String randomField, String randomSuffix) {
        super(randomField);
        this.randomSuffix = randomSuffix;
    }

    public CustomSuggestionBuilder(StreamInput in) throws IOException {
        super(in);
        this.randomSuffix = in.readString();
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.randomSuffix);
    }

    protected XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RANDOM_SUFFIX_FIELD.getPreferredName(), this.randomSuffix);
        return builder;
    }

    public String getWriteableName() {
        return SUGGESTION_NAME;
    }

    protected boolean doEquals(CustomSuggestionBuilder other) {
        return Objects.equals(this.randomSuffix, other.randomSuffix);
    }

    protected int doHashCode() {
        return Objects.hash(this.randomSuffix);
    }

    public static CustomSuggestionBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        String fieldname = null;
        String suffix = null;
        String analyzer = null;
        int sizeField = -1;
        int shardSize = -1;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (SuggestionBuilder.ANALYZER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    analyzer = parser.text();
                    continue;
                }
                if (SuggestionBuilder.FIELDNAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fieldname = parser.text();
                    continue;
                }
                if (SuggestionBuilder.SIZE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    sizeField = parser.intValue();
                    continue;
                }
                if (SuggestionBuilder.SHARDSIZE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    shardSize = parser.intValue();
                    continue;
                }
                if (!RANDOM_SUFFIX_FIELD.match(currentFieldName, parser.getDeprecationHandler())) continue;
                suffix = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "suggester[custom] doesn't support field [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldname == null) {
            throw new ParsingException(parser.getTokenLocation(), "the required field option is missing", new Object[0]);
        }
        CustomSuggestionBuilder builder = new CustomSuggestionBuilder(fieldname, suffix);
        if (analyzer != null) {
            builder.analyzer(analyzer);
        }
        if (sizeField != -1) {
            builder.size(sizeField);
        }
        if (shardSize != -1) {
            builder.shardSize(shardSize);
        }
        return builder;
    }

    public SuggestionSearchContext.SuggestionContext build(QueryShardContext context) throws IOException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(FIELDNAME_FIELD.getPreferredName(), this.field());
        options.put(RANDOM_SUFFIX_FIELD.getPreferredName(), this.randomSuffix);
        CustomSuggestionContext customSuggestionsContext = new CustomSuggestionContext(context, options);
        customSuggestionsContext.setField(this.field());
        assert (this.text != null);
        customSuggestionsContext.setText(BytesRefs.toBytesRef((Object)this.text));
        return customSuggestionsContext;
    }
}

