/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.example.customsuggester;

import java.io.IOException;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.text.Text;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.search.suggest.Suggest;

public class CustomSuggestion
extends Suggest.Suggestion<Entry> {
    public static final int TYPE = 999;
    public static final ParseField DUMMY = new ParseField("dummy", new String[0]);
    private String dummy;

    public CustomSuggestion(String name, int size, String dummy) {
        super(name, size);
        this.dummy = dummy;
    }

    public CustomSuggestion(StreamInput in) throws IOException {
        super(in);
        this.dummy = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.dummy);
    }

    public String getWriteableName() {
        return "custom";
    }

    public int getWriteableType() {
        return 999;
    }

    public String getDummy() {
        return this.dummy;
    }

    protected Entry newEntry(StreamInput in) throws IOException {
        return new Entry(in);
    }

    public static CustomSuggestion fromXContent(XContentParser parser, String name) throws IOException {
        CustomSuggestion suggestion = new CustomSuggestion(name, -1, null);
        CustomSuggestion.parseEntries((XContentParser)parser, (Suggest.Suggestion)suggestion, Entry::fromXContent);
        return suggestion;
    }

    public static class Entry
    extends Suggest.Suggestion.Entry<Option> {
        private static final ObjectParser<Entry, Void> PARSER = new ObjectParser("CustomSuggestionEntryParser", true, Entry::new);
        private String dummy;

        public Entry() {
        }

        public Entry(Text text, int offset, int length, String dummy) {
            super(text, offset, length);
            this.dummy = dummy;
        }

        public Entry(StreamInput in) throws IOException {
            super(in);
            this.dummy = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.dummy);
        }

        protected Option newOption(StreamInput in) throws IOException {
            return new Option(in);
        }

        protected void merge(Suggest.Suggestion.Entry<Option> otherEntry) {
            this.dummy = ((Entry)otherEntry).getDummy();
        }

        public String getDummy() {
            return this.dummy;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder = super.toXContent(builder, params);
            builder.field(DUMMY.getPreferredName(), this.getDummy());
            return builder;
        }

        public static Entry fromXContent(XContentParser parser) {
            return (Entry)((Object)PARSER.apply(parser, null));
        }

        static {
            Entry.declareCommonFields(PARSER);
            PARSER.declareString((entry, dummy) -> {
                entry.dummy = dummy;
            }, DUMMY);
            PARSER.declareObjectArray((e, o) -> e.addOptions(o), (p, c) -> Option.fromXContent(p), new ParseField("options", new String[0]));
        }

        public static class Option
        extends Suggest.Suggestion.Entry.Option {
            private static final ConstructingObjectParser<Option, Void> PARSER = new ConstructingObjectParser("CustomSuggestionObjectParser", true, args -> {
                Text text = new Text((String)args[0]);
                float score = ((Float)args[1]).floatValue();
                String dummy = (String)args[2];
                return new Option(text, score, dummy);
            });
            private String dummy;

            public Option(Text text, float score, String dummy) {
                super(text, score);
                this.dummy = dummy;
            }

            public Option(StreamInput in) throws IOException {
                super(in);
                this.dummy = in.readString();
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                out.writeString(this.dummy);
            }

            public String getDummy() {
                return this.dummy;
            }

            protected void mergeInto(Suggest.Suggestion.Entry.Option otherOption) {
                super.mergeInto(otherOption);
                this.dummy = ((Option)otherOption).getDummy();
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder = super.toXContent(builder, params);
                builder.field(DUMMY.getPreferredName(), this.dummy);
                return builder;
            }

            public static Option fromXContent(XContentParser parser) {
                return (Option)((Object)PARSER.apply(parser, null));
            }

            static {
                PARSER.declareString(ConstructingObjectParser.constructorArg(), TEXT);
                PARSER.declareFloat(ConstructingObjectParser.constructorArg(), SCORE);
                PARSER.declareString(ConstructingObjectParser.constructorArg(), DUMMY);
            }
        }
    }
}

