/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.example.customsuggester;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.CharsRefBuilder;
import org.opensearch.core.common.text.Text;
import org.opensearch.example.customsuggester.CustomSuggestion;
import org.opensearch.example.customsuggester.CustomSuggestionContext;
import org.opensearch.search.suggest.Suggest;
import org.opensearch.search.suggest.Suggester;

public class CustomSuggester
extends Suggester<CustomSuggestionContext> {
    public Suggest.Suggestion<? extends Suggest.Suggestion.Entry<? extends Suggest.Suggestion.Entry.Option>> innerExecute(String name, CustomSuggestionContext suggestion, IndexSearcher searcher, CharsRefBuilder spare) throws IOException {
        CustomSuggestion response = this.emptySuggestion(name, suggestion, spare);
        CustomSuggestion.Entry entry = (CustomSuggestion.Entry)((Object)response.getEntries().get(0));
        String text = entry.getText().string();
        String firstOption = String.format(Locale.ROOT, "%s-%s-%s-%s", text, suggestion.getField(), suggestion.options.get("suffix"), "12");
        CustomSuggestion.Entry.Option option12 = new CustomSuggestion.Entry.Option(new Text(firstOption), 0.9f, "option-dummy-value-1");
        entry.addOption(option12);
        String secondOption = String.format(Locale.ROOT, "%s-%s-%s-%s", text, suggestion.getField(), suggestion.options.get("suffix"), "123");
        CustomSuggestion.Entry.Option option123 = new CustomSuggestion.Entry.Option(new Text(secondOption), 0.8f, "option-dummy-value-2");
        entry.addOption(option123);
        return response;
    }

    protected CustomSuggestion emptySuggestion(String name, CustomSuggestionContext suggestion, CharsRefBuilder spare) throws IOException {
        String text = suggestion.getText().utf8ToString();
        CustomSuggestion response = new CustomSuggestion(name, suggestion.getSize(), "suggestion-dummy-value");
        CustomSuggestion.Entry entry = new CustomSuggestion.Entry(new Text(text), 0, text.length(), "entry-dummy-value");
        response.addTerm(entry);
        return response;
    }
}

