/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.rpc;

import io.moderne.jsonrpc.JsonRpc;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.Environment;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.javascript.rpc.InstallRecipesByFile;
import org.openrewrite.javascript.rpc.InstallRecipesByPackage;
import org.openrewrite.javascript.rpc.InstallRecipesResponse;
import org.openrewrite.rpc.RewriteRpc;
import org.openrewrite.rpc.RewriteRpcProcess;
import org.openrewrite.rpc.RewriteRpcProcessManager;

public class JavaScriptRewriteRpc
extends RewriteRpc {
    private static final RewriteRpcProcessManager<JavaScriptRewriteRpc> MANAGER = new RewriteRpcProcessManager((Supplier)JavaScriptRewriteRpc.builder());

    JavaScriptRewriteRpc(JsonRpc jsonRpc, Environment marketplace) {
        super(jsonRpc, marketplace);
    }

    public static JavaScriptRewriteRpc getOrStart() {
        return (JavaScriptRewriteRpc)MANAGER.getOrStart();
    }

    public static void setFactory(Builder builder) {
        MANAGER.setFactory((Supplier)builder);
    }

    public static void shutdownCurrent() {
        MANAGER.shutdown();
    }

    public int installRecipes(File recipes) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByFile(recipes), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public int installRecipes(String packageName) {
        return this.installRecipes(packageName, null);
    }

    public int installRecipes(String packageName, @Nullable String version) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByPackage(new InstallRecipesByPackage.Package(packageName, version)), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements Supplier<JavaScriptRewriteRpc> {
        private Environment marketplace = Environment.builder().build();
        private Path npxPath = Paths.get("npx", new String[0]);
        private @Nullable Path log;
        private @Nullable Path recipeInstallDir;
        private Duration timeout = Duration.ofSeconds(30L);
        private boolean verboseLogging;
        private @Nullable Integer inspectBrk;

        public Builder marketplace(Environment marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public Builder recipeInstallDir(@Nullable Path recipeInstallDir) {
            this.recipeInstallDir = recipeInstallDir;
            return this;
        }

        public Builder npxPath(Path npxPath) {
            if (Files.notExists(npxPath, new LinkOption[0]) || Files.isDirectory(npxPath, new LinkOption[0])) {
                throw new IllegalArgumentException("Invalid npx executable " + npxPath.toAbsolutePath().normalize());
            }
            this.npxPath = npxPath;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder log(@Nullable Path log) {
            this.log = log;
            return this;
        }

        public Builder verboseLogging(boolean verboseLogging) {
            this.verboseLogging = verboseLogging;
            return this;
        }

        public Builder verboseLogging() {
            return this.verboseLogging(true);
        }

        public Builder inspectBrk(@Nullable Integer inspectBrk) {
            this.inspectBrk = inspectBrk;
            return this;
        }

        public Builder inspectBrk() {
            return this.inspectBrk(9229);
        }

        @Override
        public JavaScriptRewriteRpc get() {
            StringJoiner nodeOptions = new StringJoiner(" ");
            nodeOptions.add("--enable-source-maps");
            if (this.inspectBrk != null) {
                nodeOptions.add("--inspect-brk=" + this.inspectBrk);
            }
            String version = StringUtils.readFully((InputStream)this.getClass().getResourceAsStream("/META-INF/version.txt"));
            String[] cmd = (String[])Stream.of(this.npxPath.toString(), version.endsWith("-SNAPSHOT") ? null : "--package=@openrewrite/rewrite@" + version, "rewrite-rpc", this.log == null ? null : "--log-file=" + this.log.toAbsolutePath().normalize(), this.verboseLogging ? "--verbose" : null, "--trace-get-object-output", this.recipeInstallDir == null ? null : "--recipe-install-dir=" + this.recipeInstallDir.toAbsolutePath().normalize().toString()).filter(Objects::nonNull).toArray(String[]::new);
            RewriteRpcProcess process = new RewriteRpcProcess(cmd);
            if (!nodeOptions.toString().isEmpty()) {
                process.environment().put("NODE_OPTIONS", nodeOptions.toString());
            }
            process.start();
            return (JavaScriptRewriteRpc)new JavaScriptRewriteRpc(process.getRpcClient(), this.marketplace).livenessCheck(() -> ((RewriteRpcProcess)process).getLivenessCheck()).timeout(this.timeout);
        }

        @Generated
        public Builder() {
        }
    }
}

