/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp.remote;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.remote.AbstractRemotingServerEngine;

public class DotNetRemotingServerEngine
extends AbstractRemotingServerEngine {
    @Generated
    private static final Logger log = Logger.getLogger(DotNetRemotingServerEngine.class.getName());
    public static final String REWRITE_SERVER_DLL_NAME = "Rewrite.Server.dll";
    public static final URL REWRITE_SERVER_DLL_RESOURCE = Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResource("DotnetServer.zip"));
    public static final int DEFAULT_DEBUG_PORT = 54321;
    Config config;

    public static DotNetRemotingServerEngine create(Path extractedDotnetBinariesDir) {
        return DotNetRemotingServerEngine.create(Config.builder().extractedDotnetBinaryDir(extractedDotnetBinariesDir).build());
    }

    public static DotNetRemotingServerEngine create(Config config) {
        DotNetRemotingServerEngine.installExecutable(config.dotnetServerZipLocation, config.extractedDotnetBinaryDir.toFile());
        return new DotNetRemotingServerEngine(config);
    }

    private DotNetRemotingServerEngine(Config config) {
        super(new InetSocketAddress(InetAddress.getLoopbackAddress(), config.port), Duration.ofMillis(config.timeoutInMilliseconds));
        this.config = config;
    }

    protected ProcessBuilder configureProcess(ProcessBuilder processBuilder) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.config.dotnetExecutable);
        command.add(this.config.extractedDotnetBinaryDir.resolve(this.config.dotnetServerDllName).toString());
        command.add("-p" + this.config.port);
        command.add("-t" + this.config.timeoutInMilliseconds);
        if (this.config.logFilePath != null && !this.config.logFilePath.isEmpty()) {
            command.add("-l" + this.config.logFilePath);
        }
        if (this.config.nugetPackagesFolder != null && !this.config.nugetPackagesFolder.isEmpty()) {
            command.add("-f" + this.config.nugetPackagesFolder);
        }
        return processBuilder.command(command);
    }

    private static void installExecutable(URL executable, File destDir) {
        byte[] buffer = new byte[1024];
        try (ZipInputStream zis = new ZipInputStream(executable.openStream());){
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File newFile = DotNetRemotingServerEngine.newFile(destDir, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!(newFile.isDirectory() || newFile.mkdirs() || newFile.isDirectory())) {
                        throw new IOException("Failed to create directory " + newFile);
                    }
                } else {
                    File parent = newFile.getParentFile();
                    if (!parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + parent);
                    }
                    try (FileOutputStream fos = new FileOutputStream(newFile);){
                        int len;
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                    }
                }
                zipEntry = zis.getNextEntry();
            }
        }
    }

    public String getLanguageName() {
        return "CSharp";
    }

    static File newFile(File destinationDir, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDir, zipEntry.getName());
        String destDirPath = destinationDir.getCanonicalPath();
        String destFilePath = destFile.getCanonicalPath();
        if (!destFilePath.startsWith(destDirPath + File.separator)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }

    public static class Config {
        int port;
        int timeoutInMilliseconds;
        @Nullable String logFilePath;
        @Nullable String nugetPackagesFolder;
        String dotnetExecutable;
        Path extractedDotnetBinaryDir;
        URL dotnetServerZipLocation;
        String dotnetServerDllName;

        @Generated
        private static int $default$port() {
            return 54321;
        }

        @Generated
        private static int $default$timeoutInMilliseconds() {
            return (int)Duration.ofHours(1L).toMillis();
        }

        @Generated
        private static String $default$logFilePath() {
            return null;
        }

        @Generated
        private static String $default$nugetPackagesFolder() {
            return null;
        }

        @Generated
        private static String $default$dotnetExecutable() {
            return "dotnet";
        }

        @Generated
        private static URL $default$dotnetServerZipLocation() {
            return REWRITE_SERVER_DLL_RESOURCE;
        }

        @Generated
        private static String $default$dotnetServerDllName() {
            return DotNetRemotingServerEngine.REWRITE_SERVER_DLL_NAME;
        }

        @Generated
        Config(int port, int timeoutInMilliseconds, @Nullable String logFilePath, @Nullable String nugetPackagesFolder, String dotnetExecutable, Path extractedDotnetBinaryDir, URL dotnetServerZipLocation, String dotnetServerDllName) {
            this.port = port;
            this.timeoutInMilliseconds = timeoutInMilliseconds;
            this.logFilePath = logFilePath;
            this.nugetPackagesFolder = nugetPackagesFolder;
            this.dotnetExecutable = dotnetExecutable;
            this.extractedDotnetBinaryDir = extractedDotnetBinaryDir;
            this.dotnetServerZipLocation = dotnetServerZipLocation;
            this.dotnetServerDllName = dotnetServerDllName;
        }

        @Generated
        public static ConfigBuilder builder() {
            return new ConfigBuilder();
        }

        @Generated
        public static class ConfigBuilder {
            @Generated
            private boolean port$set;
            @Generated
            private int port$value;
            @Generated
            private boolean timeoutInMilliseconds$set;
            @Generated
            private int timeoutInMilliseconds$value;
            @Generated
            private boolean logFilePath$set;
            @Generated
            private String logFilePath$value;
            @Generated
            private boolean nugetPackagesFolder$set;
            @Generated
            private String nugetPackagesFolder$value;
            @Generated
            private boolean dotnetExecutable$set;
            @Generated
            private String dotnetExecutable$value;
            @Generated
            private Path extractedDotnetBinaryDir;
            @Generated
            private boolean dotnetServerZipLocation$set;
            @Generated
            private URL dotnetServerZipLocation$value;
            @Generated
            private boolean dotnetServerDllName$set;
            @Generated
            private String dotnetServerDllName$value;

            @Generated
            ConfigBuilder() {
            }

            @Generated
            public ConfigBuilder port(int port) {
                this.port$value = port;
                this.port$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder timeoutInMilliseconds(int timeoutInMilliseconds) {
                this.timeoutInMilliseconds$value = timeoutInMilliseconds;
                this.timeoutInMilliseconds$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder logFilePath(@Nullable String logFilePath) {
                this.logFilePath$value = logFilePath;
                this.logFilePath$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder nugetPackagesFolder(@Nullable String nugetPackagesFolder) {
                this.nugetPackagesFolder$value = nugetPackagesFolder;
                this.nugetPackagesFolder$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder dotnetExecutable(String dotnetExecutable) {
                this.dotnetExecutable$value = dotnetExecutable;
                this.dotnetExecutable$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder extractedDotnetBinaryDir(Path extractedDotnetBinaryDir) {
                this.extractedDotnetBinaryDir = extractedDotnetBinaryDir;
                return this;
            }

            @Generated
            public ConfigBuilder dotnetServerZipLocation(URL dotnetServerZipLocation) {
                this.dotnetServerZipLocation$value = dotnetServerZipLocation;
                this.dotnetServerZipLocation$set = true;
                return this;
            }

            @Generated
            public ConfigBuilder dotnetServerDllName(String dotnetServerDllName) {
                this.dotnetServerDllName$value = dotnetServerDllName;
                this.dotnetServerDllName$set = true;
                return this;
            }

            @Generated
            public Config build() {
                int port$value = this.port$value;
                if (!this.port$set) {
                    port$value = Config.$default$port();
                }
                int timeoutInMilliseconds$value = this.timeoutInMilliseconds$value;
                if (!this.timeoutInMilliseconds$set) {
                    timeoutInMilliseconds$value = Config.$default$timeoutInMilliseconds();
                }
                String logFilePath$value = this.logFilePath$value;
                if (!this.logFilePath$set) {
                    logFilePath$value = Config.$default$logFilePath();
                }
                String nugetPackagesFolder$value = this.nugetPackagesFolder$value;
                if (!this.nugetPackagesFolder$set) {
                    nugetPackagesFolder$value = Config.$default$nugetPackagesFolder();
                }
                String dotnetExecutable$value = this.dotnetExecutable$value;
                if (!this.dotnetExecutable$set) {
                    dotnetExecutable$value = Config.$default$dotnetExecutable();
                }
                URL dotnetServerZipLocation$value = this.dotnetServerZipLocation$value;
                if (!this.dotnetServerZipLocation$set) {
                    dotnetServerZipLocation$value = Config.$default$dotnetServerZipLocation();
                }
                String dotnetServerDllName$value = this.dotnetServerDllName$value;
                if (!this.dotnetServerDllName$set) {
                    dotnetServerDllName$value = Config.$default$dotnetServerDllName();
                }
                return new Config(port$value, timeoutInMilliseconds$value, logFilePath$value, nugetPackagesFolder$value, dotnetExecutable$value, this.extractedDotnetBinaryDir, dotnetServerZipLocation$value, dotnetServerDllName$value);
            }

            @Generated
            public String toString() {
                return "DotNetRemotingServerEngine.Config.ConfigBuilder(port$value=" + this.port$value + ", timeoutInMilliseconds$value=" + this.timeoutInMilliseconds$value + ", logFilePath$value=" + this.logFilePath$value + ", nugetPackagesFolder$value=" + this.nugetPackagesFolder$value + ", dotnetExecutable$value=" + this.dotnetExecutable$value + ", extractedDotnetBinaryDir=" + this.extractedDotnetBinaryDir + ", dotnetServerZipLocation$value=" + this.dotnetServerZipLocation$value + ", dotnetServerDllName$value=" + this.dotnetServerDllName$value + ")";
            }
        }
    }
}

