/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.Collections;
import java.util.UUID;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@AutoConfigure
public class StringLiteralEquality
extends CheckstyleRefactorVisitor {
    public J visitBinary(J.Binary binary) {
        if (binary.getOperator() instanceof J.Binary.Operator.Equal && (this.isStringLiteral(binary.getLeft()) || this.isStringLiteral(binary.getRight()))) {
            Expression left = this.isStringLiteral(binary.getRight()) ? binary.getRight() : binary.getLeft();
            Expression right = this.isStringLiteral(binary.getRight()) ? binary.getLeft() : binary.getRight();
            return new J.MethodInvocation(Tree.randomId(), (Expression)left.withFormatting(Formatting.EMPTY), null, J.Ident.build((UUID)Tree.randomId(), (String)"equals", (JavaType)JavaType.Primitive.Boolean, (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), Collections.singletonList((Expression)right.withFormatting(Formatting.EMPTY)), Formatting.EMPTY), JavaType.Method.build((JavaType.FullyQualified)JavaType.Class.build((String)"java.lang.Object"), (String)"equals", null, null, Collections.singletonList("o"), Collections.singleton(Flag.Public)), binary.getFormatting());
        }
        return super.visitBinary(binary);
    }

    public boolean isStringLiteral(Expression expression) {
        return expression instanceof J.Literal && ((J.Literal)expression).getType() == JavaType.Primitive.String;
    }
}

