/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class HideUtilityClassConstructor
extends CheckstyleRefactorVisitor {
    public J visitClassDecl(J.ClassDecl classDecl) {
        J.ClassDecl c = (J.ClassDecl)this.refactor((Tree)classDecl, x$0 -> super.visitClassDecl(x$0));
        if (classDecl.getBody().getStatements().stream().allMatch(s -> !(s instanceof J.MethodDecl) || !((J.MethodDecl)s).isConstructor() || !((J.MethodDecl)s).hasModifier("static"))) {
            c = c.withBody(c.getBody().withStatements(c.getBody().getStatements().stream().map(s -> {
                J.MethodDecl ctor = (J.MethodDecl)s;
                if (ctor.isConstructor() && !ctor.hasModifier("private")) {
                    List modifiers = ctor.getModifiers();
                    int insertPosition = 0;
                    for (int i = 0; i < modifiers.size(); ++i) {
                        J.Modifier modifier = (J.Modifier)modifiers.get(i);
                        if (!(modifier instanceof J.Modifier.Public)) continue;
                        insertPosition = i;
                    }
                    modifiers.set(insertPosition, new J.Modifier.Private(Tree.randomId(), ((J.Modifier)modifiers.get(insertPosition)).getFormatting()));
                    return ctor.withModifiers(modifiers);
                }
                return ctor;
            }).collect(Collectors.toList())));
        }
        return c;
    }
}

