/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.policy.OperatorToken;
import org.openrewrite.checkstyle.policy.WrapPolicy;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeTree;

@AutoConfigure
public class OperatorWrap
extends CheckstyleRefactorVisitor {
    private static final Set<OperatorToken> DEFAULT_TOKENS = Set.of(OperatorToken.QUESTION, OperatorToken.COLON, OperatorToken.EQUAL, OperatorToken.NOT_EQUAL, OperatorToken.DIV, OperatorToken.PLUS, OperatorToken.MINUS, OperatorToken.STAR, OperatorToken.MOD, OperatorToken.SR, OperatorToken.BSR, OperatorToken.GE, OperatorToken.GT, OperatorToken.SL, OperatorToken.LE, OperatorToken.LT, OperatorToken.BXOR, OperatorToken.BOR, OperatorToken.LOR, OperatorToken.BAND, OperatorToken.LAND, OperatorToken.TYPE_EXTENSION_AND, OperatorToken.LITERAL_INSTANCEOF);
    private WrapPolicy option;
    private Set<OperatorToken> tokens;

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.option = m.propAsOptionValue(WrapPolicy::valueOf, WrapPolicy.NL);
        this.tokens = m.propAsTokens(OperatorToken.class, DEFAULT_TOKENS);
    }

    public Iterable<Tag> getTags() {
        return Tags.of((String)"policy", (String)this.option.toString());
    }

    public J visitBinary(J.Binary binary) {
        J.Binary b = (J.Binary)this.refactor((Tree)binary, x$0 -> super.visitBinary(x$0));
        J.Binary.Operator op = binary.getOperator();
        if (this.tokens.contains((Object)OperatorToken.DIV) && op instanceof J.Binary.Operator.Division || this.tokens.contains((Object)OperatorToken.STAR) && op instanceof J.Binary.Operator.Multiplication || this.tokens.contains((Object)OperatorToken.PLUS) && op instanceof J.Binary.Operator.Addition || this.tokens.contains((Object)OperatorToken.MINUS) && op instanceof J.Binary.Operator.Subtraction || this.tokens.contains((Object)OperatorToken.MOD) && op instanceof J.Binary.Operator.Modulo || this.tokens.contains((Object)OperatorToken.SR) && op instanceof J.Binary.Operator.RightShift || this.tokens.contains((Object)OperatorToken.SL) && op instanceof J.Binary.Operator.LeftShift || this.tokens.contains((Object)OperatorToken.BSR) && op instanceof J.Binary.Operator.UnsignedRightShift || this.tokens.contains((Object)OperatorToken.EQUAL) && op instanceof J.Binary.Operator.Equal || this.tokens.contains((Object)OperatorToken.NOT_EQUAL) && op instanceof J.Binary.Operator.NotEqual || this.tokens.contains((Object)OperatorToken.GT) && op instanceof J.Binary.Operator.GreaterThan || this.tokens.contains((Object)OperatorToken.GE) && op instanceof J.Binary.Operator.GreaterThanOrEqual || this.tokens.contains((Object)OperatorToken.LT) && op instanceof J.Binary.Operator.LessThan || this.tokens.contains((Object)OperatorToken.LE) && op instanceof J.Binary.Operator.LessThanOrEqual || this.tokens.contains((Object)OperatorToken.BAND) && op instanceof J.Binary.Operator.BitAnd || this.tokens.contains((Object)OperatorToken.BXOR) && op instanceof J.Binary.Operator.BitXor || this.tokens.contains((Object)OperatorToken.BOR) && op instanceof J.Binary.Operator.BitOr || this.tokens.contains((Object)OperatorToken.LAND) && op instanceof J.Binary.Operator.And || this.tokens.contains((Object)OperatorToken.LOR) && op instanceof J.Binary.Operator.Or) {
            if (this.option == WrapPolicy.NL) {
                if (binary.getRight().getFormatting().getPrefix().contains("\n")) {
                    b = b.withOperator((J.Binary.Operator)b.getOperator().withPrefix(b.getRight().getFormatting().getPrefix())).withRight((Expression)b.getRight().withPrefix(" "));
                }
            } else if (op.getFormatting().getPrefix().contains("\n")) {
                b = b.withOperator((J.Binary.Operator)b.getOperator().withPrefix(" ")).withRight((Expression)b.getRight().withPrefix(op.getFormatting().getPrefix()));
            }
        }
        return b;
    }

    public J visitTypeParameter(J.TypeParameter typeParam) {
        J.TypeParameter t = (J.TypeParameter)this.refactor((Tree)typeParam, x$0 -> super.visitTypeParameter(x$0));
        if (this.tokens.contains((Object)OperatorToken.TYPE_EXTENSION_AND) && t.getBounds() != null) {
            ArrayList<TypeTree> types = new ArrayList<TypeTree>(t.getBounds().getTypes());
            boolean changed = false;
            for (int i = 0; i < types.size() - 1; ++i) {
                TypeTree tp1 = (TypeTree)types.get(i);
                TypeTree tp2 = (TypeTree)types.get(i + 1);
                if (this.option == WrapPolicy.NL) {
                    if (!tp2.getFormatting().getPrefix().contains("\n")) continue;
                    tp1 = (TypeTree)tp1.withSuffix(tp2.getFormatting().getPrefix());
                    tp2 = (TypeTree)tp2.withPrefix(" ");
                    changed = true;
                    types.set(i, tp1);
                    types.set(i + 1, tp2);
                    continue;
                }
                if (!tp1.getFormatting().getSuffix().contains("\n")) continue;
                tp2 = (TypeTree)tp2.withPrefix(tp1.getFormatting().getSuffix());
                tp1 = (TypeTree)tp1.withSuffix(" ");
                changed = true;
                types.set(i, tp1);
                types.set(i + 1, tp2);
            }
            if (changed) {
                t = t.withBounds(t.getBounds().withTypes(types));
            }
        }
        return t;
    }

    public J visitInstanceOf(J.InstanceOf instanceOf) {
        J.InstanceOf i = (J.InstanceOf)this.refactor((Tree)instanceOf, x$0 -> super.visitInstanceOf(x$0));
        if (this.tokens.contains((Object)OperatorToken.LITERAL_INSTANCEOF)) {
            if (this.option == WrapPolicy.NL) {
                if (instanceOf.getClazz().getFormatting().getPrefix().contains("\n")) {
                    i = i.withExpr((Expression)i.getExpr().withSuffix(i.getClazz().getFormatting().getPrefix())).withClazz(i.getClazz().withPrefix(" "));
                }
            } else if (instanceOf.getExpr().getFormatting().getSuffix().contains("\n")) {
                i = i.withExpr((Expression)i.getExpr().withSuffix(" ")).withClazz(i.getClazz().withPrefix(i.getExpr().getFormatting().getSuffix()));
            }
        }
        return i;
    }

    public J visitTernary(J.Ternary ternary) {
        J.Ternary t = (J.Ternary)this.refactor((Tree)ternary, x$0 -> super.visitTernary(x$0));
        if (this.tokens.contains((Object)OperatorToken.QUESTION)) {
            if (this.option == WrapPolicy.NL) {
                if (ternary.getTruePart().getFormatting().getPrefix().contains("\n")) {
                    t = t.withCondition((Expression)t.getCondition().withSuffix(t.getTruePart().getFormatting().getPrefix())).withTruePart((Expression)t.getTruePart().withPrefix(" "));
                }
            } else if (ternary.getCondition().getFormatting().getSuffix().contains("\n")) {
                t = t.withCondition((Expression)t.getCondition().withSuffix(" ")).withTruePart((Expression)t.getTruePart().withPrefix(t.getCondition().getFormatting().getSuffix()));
            }
        }
        if (this.tokens.contains((Object)OperatorToken.COLON)) {
            if (this.option == WrapPolicy.NL) {
                if (ternary.getFalsePart().getFormatting().getPrefix().contains("\n")) {
                    t = t.withTruePart((Expression)t.getTruePart().withSuffix(t.getFalsePart().getFormatting().getPrefix())).withFalsePart((Expression)t.getFalsePart().withPrefix(" "));
                }
            } else if (ternary.getTruePart().getFormatting().getSuffix().contains("\n")) {
                t = t.withTruePart((Expression)t.getTruePart().withSuffix(" ")).withFalsePart((Expression)t.getFalsePart().withPrefix(t.getTruePart().getFormatting().getSuffix()));
            }
        }
        return t;
    }

    public J visitAssignOp(J.AssignOp assignOp) {
        J.AssignOp a = (J.AssignOp)this.refactor((Tree)assignOp, x$0 -> super.visitAssignOp(x$0));
        J.AssignOp.Operator op = assignOp.getOperator();
        if (this.tokens.contains((Object)OperatorToken.PLUS_ASSIGN) && op instanceof J.AssignOp.Operator.Addition || this.tokens.contains((Object)OperatorToken.MINUS_ASSIGN) && op instanceof J.AssignOp.Operator.Subtraction || this.tokens.contains((Object)OperatorToken.STAR_ASSIGN) && op instanceof J.AssignOp.Operator.Multiplication || this.tokens.contains((Object)OperatorToken.DIV_ASSIGN) && op instanceof J.AssignOp.Operator.Division || this.tokens.contains((Object)OperatorToken.MOD_ASSIGN) && op instanceof J.AssignOp.Operator.Modulo || this.tokens.contains((Object)OperatorToken.SR_ASSIGN) && op instanceof J.AssignOp.Operator.RightShift || this.tokens.contains((Object)OperatorToken.SL_ASSIGN) && op instanceof J.AssignOp.Operator.LeftShift || this.tokens.contains((Object)OperatorToken.BSR_ASSIGN) && op instanceof J.AssignOp.Operator.UnsignedRightShift || this.tokens.contains((Object)OperatorToken.BAND_ASSIGN) && op instanceof J.AssignOp.Operator.BitAnd || this.tokens.contains((Object)OperatorToken.BXOR_ASSIGN) && op instanceof J.AssignOp.Operator.BitXor || this.tokens.contains((Object)OperatorToken.BOR_ASSIGN) && op instanceof J.AssignOp.Operator.BitOr) {
            if (this.option == WrapPolicy.NL) {
                if (assignOp.getAssignment().getFormatting().getPrefix().contains("\n")) {
                    a = a.withOperator((J.AssignOp.Operator)a.getOperator().withPrefix(a.getAssignment().getFormatting().getPrefix())).withAssignment((Expression)a.getAssignment().withPrefix(" "));
                }
            } else if (op.getFormatting().getPrefix().contains("\n")) {
                a = a.withOperator((J.AssignOp.Operator)a.getOperator().withPrefix(" ")).withAssignment((Expression)a.getAssignment().withPrefix(op.getFormatting().getPrefix()));
            }
        }
        return a;
    }

    public J visitMemberReference(J.MemberReference memberRef) {
        J.MemberReference m = (J.MemberReference)this.refactor((Tree)memberRef, x$0 -> super.visitMemberReference(x$0));
        if (this.tokens.contains((Object)OperatorToken.METHOD_REF)) {
            if (this.option == WrapPolicy.NL) {
                if (memberRef.getReference().getFormatting().getPrefix().contains("\n")) {
                    m = m.withContaining((Expression)m.getContaining().withSuffix(m.getReference().getFormatting().getPrefix())).withReference((J.Ident)Formatting.stripPrefix((Tree)m.getReference()));
                }
            } else if (memberRef.getContaining().getFormatting().getSuffix().contains("\n")) {
                m = m.withContaining((Expression)Formatting.stripSuffix((Tree)m.getContaining())).withReference((J.Ident)m.getReference().withPrefix(m.getContaining().getFormatting().getSuffix()));
            }
        }
        return m;
    }

    public J visitAssign(J.Assign assign) {
        J.Assign a = (J.Assign)this.refactor((Tree)assign, x$0 -> super.visitAssign(x$0));
        if (this.tokens.contains((Object)OperatorToken.ASSIGN)) {
            if (this.option == WrapPolicy.NL) {
                if (assign.getAssignment().getFormatting().getPrefix().contains("\n")) {
                    a = a.withVariable((Expression)a.getVariable().withSuffix(a.getAssignment().getFormatting().getPrefix())).withAssignment((Expression)a.getAssignment().withPrefix(" "));
                }
            } else if (assign.getVariable().getFormatting().getSuffix().contains("\n")) {
                a = a.withVariable((Expression)a.getVariable().withSuffix(" ")).withAssignment((Expression)a.getAssignment().withPrefix(a.getVariable().getFormatting().getSuffix()));
            }
        }
        return a;
    }

    public J visitVariable(J.VariableDecls.NamedVar variable) {
        J.VariableDecls.NamedVar v = (J.VariableDecls.NamedVar)this.refactor((Tree)variable, x$0 -> super.visitVariable(x$0));
        if (this.tokens.contains((Object)OperatorToken.ASSIGN) && variable.getInitializer() != null) {
            if (this.option == WrapPolicy.NL) {
                if (variable.getInitializer().getFormatting().getPrefix().contains("\n")) {
                    v = v.withDimensionsAfterName(Formatting.formatLastSuffix((List)v.getDimensionsAfterName(), (String)v.getInitializer().getFormatting().getPrefix())).withName(v.getDimensionsAfterName().isEmpty() ? (J.Ident)v.getName().withSuffix(v.getInitializer().getFormatting().getPrefix()) : v.getName()).withInitializer((Expression)v.getInitializer().withPrefix(" "));
                }
            } else if (this.lastTreeBeforeInitializer(variable).getFormatting().getSuffix().contains("\n")) {
                v = v.withDimensionsAfterName(Formatting.formatLastSuffix((List)v.getDimensionsAfterName(), (String)" ")).withName(v.getDimensionsAfterName().isEmpty() ? (J.Ident)v.getName().withSuffix(" ") : v.getName()).withInitializer((Expression)v.getInitializer().withPrefix(this.lastTreeBeforeInitializer(v).getFormatting().getSuffix()));
            }
        }
        return v;
    }

    private Tree lastTreeBeforeInitializer(J.VariableDecls.NamedVar var) {
        if (!var.getDimensionsAfterName().isEmpty()) {
            return (Tree)var.getDimensionsAfterName().get(var.getDimensionsAfterName().size() - 1);
        }
        return var.getName();
    }
}

