/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.Tree;
import org.openrewrite.checkstyle.CheckstyleRefactorVisitor;
import org.openrewrite.checkstyle.WhitespaceChecks;
import org.openrewrite.checkstyle.policy.PunctuationToken;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@AutoConfigure
public class NoWhitespaceAfter
extends CheckstyleRefactorVisitor {
    private static final Set<PunctuationToken> DEFAULT_TOKENS = Set.of(PunctuationToken.ARRAY_INIT, PunctuationToken.AT, PunctuationToken.INC, PunctuationToken.DEC, PunctuationToken.UNARY_MINUS, PunctuationToken.UNARY_PLUS, PunctuationToken.BNOT, PunctuationToken.LNOT, PunctuationToken.DOT, PunctuationToken.ARRAY_DECLARATOR, PunctuationToken.INDEX_OP);
    private boolean allowLineBreaks;
    private Set<PunctuationToken> tokens;

    public NoWhitespaceAfter() {
        this.setCursoringOn();
    }

    @Override
    protected void configure(CheckstyleRefactorVisitor.Module m) {
        this.allowLineBreaks = m.prop("allowLineBreaks", true);
        this.tokens = m.propAsTokens(PunctuationToken.class, DEFAULT_TOKENS);
    }

    public J visitTypeCast(J.TypeCast typeCast) {
        J.TypeCast t = (J.TypeCast)this.refactor((Tree)typeCast, x$0 -> super.visitTypeCast(x$0));
        if (this.tokens.contains((Object)PunctuationToken.TYPECAST) && WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace((Tree)typeCast.getExpr())) {
            t = t.withExpr(WhitespaceChecks.stripPrefixUpToLinebreak(typeCast.getExpr()));
        }
        return t;
    }

    public J visitMemberReference(J.MemberReference memberRef) {
        J.MemberReference m = (J.MemberReference)this.refactor((Tree)memberRef, x$0 -> super.visitMemberReference(x$0));
        if (this.tokens.contains((Object)PunctuationToken.METHOD_REF) && WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace((Tree)memberRef.getReference())) {
            m = m.withReference(WhitespaceChecks.stripPrefixUpToLinebreak(memberRef.getReference()));
        }
        return m;
    }

    public J visitMultiVariable(J.VariableDecls multiVariable) {
        J.VariableDecls m = (J.VariableDecls)this.refactor((Tree)multiVariable, x$0 -> super.visitMultiVariable(x$0));
        if (this.tokens.contains((Object)PunctuationToken.ARRAY_DECLARATOR) && multiVariable.getDimensionsBeforeName().stream().anyMatch(WhitespaceChecks::prefixStartsWithNonLinebreakWhitespace)) {
            m = m.withDimensionsBeforeName(m.getDimensionsBeforeName().stream().map(WhitespaceChecks::stripPrefixUpToLinebreak).collect(Collectors.toList()));
        }
        return m;
    }

    public J visitAnnotation(J.Annotation annotation) {
        J.Annotation a = (J.Annotation)this.refactor((Tree)annotation, x$0 -> super.visitAnnotation(x$0));
        if (this.tokens.contains((Object)PunctuationToken.AT) && WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace((Tree)annotation.getAnnotationType())) {
            a = a.withAnnotationType(WhitespaceChecks.stripPrefixUpToLinebreak(a.getAnnotationType()));
        }
        return a;
    }

    public J visitArrayType(J.ArrayType arrayType) {
        J.ArrayType a = (J.ArrayType)this.refactor((Tree)arrayType, x$0 -> super.visitArrayType(x$0));
        if (this.tokens.contains((Object)PunctuationToken.ARRAY_DECLARATOR) && arrayType.getDimensions().stream().anyMatch(WhitespaceChecks::prefixStartsWithNonLinebreakWhitespace)) {
            a = a.withDimensions(a.getDimensions().stream().map(WhitespaceChecks::stripPrefixUpToLinebreak).collect(Collectors.toList()));
        }
        return a;
    }

    public J visitNewArray(J.NewArray newArray) {
        J.NewArray n = (J.NewArray)this.refactor((Tree)newArray, x$0 -> super.visitNewArray(x$0));
        if (this.tokens.contains((Object)PunctuationToken.ARRAY_INIT) && this.getCursor().firstEnclosing(J.Annotation.class) == null && Optional.ofNullable(newArray.getInitializer()).map(J.NewArray.Initializer::getElements).map(init -> !init.isEmpty() && (WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace((Tree)init.get(0)) || WhitespaceChecks.suffixStartsWithNonLinebreakWhitespace((Tree)init.get(init.size() - 1)))).orElse(false).booleanValue()) {
            ArrayList<Expression> fixedInit = new ArrayList<Expression>(n.getInitializer().getElements());
            if (fixedInit.size() == 1) {
                fixedInit.set(0, (Expression)((Expression)fixedInit.get(0)).withFormatting(Formatting.EMPTY));
            } else {
                fixedInit.set(0, WhitespaceChecks.stripPrefixUpToLinebreak((Expression)fixedInit.get(0)));
                fixedInit.set(fixedInit.size() - 1, WhitespaceChecks.stripSuffixUpToLinebreak((Expression)fixedInit.get(fixedInit.size() - 1)));
            }
            n = n.withInitializer(n.getInitializer().withElements(fixedInit));
        }
        return n;
    }

    public J visitArrayAccess(J.ArrayAccess arrayAccess) {
        J.ArrayAccess a = (J.ArrayAccess)this.refactor((Tree)arrayAccess, x$0 -> super.visitArrayAccess(x$0));
        if (this.tokens.contains((Object)PunctuationToken.INDEX_OP) && WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace((Tree)arrayAccess.getDimension())) {
            a = a.withDimension(WhitespaceChecks.stripPrefixUpToLinebreak(a.getDimension()));
        }
        return a;
    }

    public J visitUnary(J.Unary unary) {
        J.Unary u = (J.Unary)this.refactor((Tree)unary, x$0 -> super.visitUnary(x$0));
        J.Unary.Operator op = unary.getOperator();
        if ((op instanceof J.Unary.Operator.PreDecrement || op instanceof J.Unary.Operator.PreIncrement || op instanceof J.Unary.Operator.Negative || op instanceof J.Unary.Operator.Positive || op instanceof J.Unary.Operator.Complement || op instanceof J.Unary.Operator.Not) && (this.tokens.contains((Object)PunctuationToken.DEC) || this.tokens.contains((Object)PunctuationToken.INC) || this.tokens.contains((Object)PunctuationToken.BNOT) || this.tokens.contains((Object)PunctuationToken.LNOT) || this.tokens.contains((Object)PunctuationToken.UNARY_PLUS) || this.tokens.contains((Object)PunctuationToken.UNARY_MINUS)) && WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace((Tree)unary.getExpr())) {
            u = u.withExpr(WhitespaceChecks.stripPrefixUpToLinebreak(u.getExpr()));
        }
        return u;
    }

    public J visitFieldAccess(J.FieldAccess fieldAccess) {
        J.FieldAccess f = (J.FieldAccess)this.refactor((Tree)fieldAccess, x$0 -> super.visitFieldAccess(x$0));
        if (this.tokens.contains((Object)PunctuationToken.DOT) && this.whitespaceInDotPrefix((Tree)fieldAccess.getName())) {
            f = f.withName(this.allowLineBreaks ? WhitespaceChecks.stripPrefixUpToLinebreak(f.getName()) : (J.Ident)Formatting.stripPrefix((Tree)f.getName()));
        }
        return f;
    }

    public J visitMethodInvocation(J.MethodInvocation method) {
        J.MethodInvocation m = (J.MethodInvocation)this.refactor((Tree)method, x$0 -> super.visitMethodInvocation(x$0));
        if (this.tokens.contains((Object)PunctuationToken.DOT) && this.whitespaceInDotPrefix((Tree)method.getName())) {
            m = m.withName(this.allowLineBreaks ? WhitespaceChecks.stripPrefixUpToLinebreak(m.getName()) : (J.Ident)Formatting.stripPrefix((Tree)m.getName()));
        }
        return m;
    }

    private boolean whitespaceInDotPrefix(@Nullable Tree t) {
        if (t == null) {
            return false;
        }
        if (this.allowLineBreaks) {
            return WhitespaceChecks.prefixStartsWithNonLinebreakWhitespace(t);
        }
        return t.getFormatting().getPrefix().chars().anyMatch(Character::isWhitespace);
    }
}

