/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.checkstyle;

import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.api.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.filters.SuppressionsLoader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaRefactorVisitor;
import org.openrewrite.java.tree.J;
import org.xml.sax.InputSource;

public abstract class CheckstyleRefactorVisitor
extends JavaRefactorVisitor {
    private static final LocalizedMessage localizedMessageThatDoesntMatter = new LocalizedMessage(1, "bundle", "key", (Object[])new String[0], null, CheckstyleRefactorVisitor.class, null);
    private static final Map<File, LoadedConfiguration> loadedConfigurationsByPath = new HashMap<File, LoadedConfiguration>();
    private File configFile;
    private String config;
    private Map<String, Object> properties;
    private FilterSet suppressions = new FilterSet();

    public J visitCompilationUnit(J.CompilationUnit cu) {
        if (this.suppressions.accept(new AuditEvent((Object)"does not matter", cu.getSourcePath(), localizedMessageThatDoesntMatter))) {
            return super.visitCompilationUnit(cu);
        }
        return cu;
    }

    public void setConfig(String config) {
        this.config = config;
        this.validate();
    }

    public void setConfigFile(File configFile) {
        this.configFile = configFile;
        this.validate();
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
        this.validate();
    }

    protected void configure(Module m) {
    }

    public final Validated validate() {
        try {
            Module module;
            InputStream inputStream;
            LoadedConfiguration loadedConfiguration;
            if (this.configFile != null && this.configFile.exists()) {
                loadedConfiguration = loadedConfigurationsByPath.get(this.configFile);
                if (loadedConfiguration == null) {
                    inputStream = new FileInputStream(this.configFile);
                    try {
                        loadedConfiguration = this.loadConfiguration(inputStream);
                        loadedConfigurationsByPath.put(this.configFile, loadedConfiguration);
                    }
                    finally {
                        inputStream.close();
                    }
                }
            } else if (this.config != null) {
                inputStream = new ByteArrayInputStream(this.config.getBytes(Charset.defaultCharset()));
                try {
                    loadedConfiguration = this.loadConfiguration(inputStream);
                }
                finally {
                    inputStream.close();
                }
            } else {
                return Validated.missing((String)"config", null, (String)"Either config or configFile must be specified");
            }
            if ((module = loadedConfiguration.modulesByName.get(((Object)((Object)this)).getClass().getSimpleName())) == null) {
                return Validated.missing((String)"config", null, (String)"No matching module found in the checkstyle configuration");
            }
            this.suppressions = loadedConfiguration.suppressions;
            this.configure(module);
            return Validated.valid((String)"config", (Object)((Object)this));
        }
        catch (CheckstyleException | IOException e) {
            return Validated.invalid((String)"config", (Object)(this.config == null ? this.configFile.getPath() : this.config), (String)"Checkstyle configuration could not be loaded", (Throwable)e);
        }
    }

    private LoadedConfiguration loadConfiguration(InputStream inputStream) throws CheckstyleException {
        Configuration checkstyleConfig = ConfigurationLoader.loadConfiguration((InputSource)new InputSource(inputStream), name -> {
            Object prop = this.properties.get(name);
            return prop == null ? (name.equals("config_loc") ? "config/checkstyle" : null) : prop.toString();
        }, (ConfigurationLoader.IgnoredModulesOptions)ConfigurationLoader.IgnoredModulesOptions.OMIT);
        FilterSet suppressions = new FilterSet();
        for (Configuration firstLevelChild : checkstyleConfig.getChildren()) {
            if (!"SuppressionFilter".equals(firstLevelChild.getName())) continue;
            for (String attributeName : firstLevelChild.getAttributeNames()) {
                if (!"file".equals(attributeName)) continue;
                suppressions = SuppressionsLoader.loadSuppressions((String)firstLevelChild.getAttribute("file"));
            }
        }
        ArrayList<Module> modules = new ArrayList<Module>();
        for (Configuration firstLevelChild : checkstyleConfig.getChildren()) {
            if (!"TreeWalker".equals(firstLevelChild.getName())) continue;
            modules.addAll(Arrays.stream(firstLevelChild.getChildren()).map(child -> {
                try {
                    HashMap<String, String> properties = new HashMap<String, String>();
                    for (String propertyName : child.getAttributeNames()) {
                        properties.put(propertyName, child.getAttribute(propertyName));
                    }
                    return new Module(child.getName(), properties);
                }
                catch (CheckstyleException e) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return new LoadedConfiguration(modules, suppressions);
    }

    protected static class Module {
        private final String name;
        private final Map<String, String> properties;

        public Module(String name, Map<String, String> properties) {
            this.name = name;
            this.properties = properties;
        }

        public String getName() {
            return this.name;
        }

        public boolean prop(String key, boolean defaultValue) {
            return this.properties.containsKey(key) ? Boolean.parseBoolean(this.properties.get(key)) : defaultValue;
        }

        public Pattern prop(String key, Pattern defaultValue) {
            if (this.properties.containsKey(key)) {
                try {
                    return Pattern.compile(this.properties.get(key));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return defaultValue;
        }

        public <T extends Enum<T>> Set<T> propAsTokens(Class<T> enumType, Set<T> defaultValue) {
            return this.properties.containsKey("tokens") ? Arrays.stream(this.properties.get("tokens").split("\\s*,\\s*")).map(token -> {
                try {
                    return Enum.valueOf(enumType, token);
                }
                catch (Throwable t) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toSet()) : defaultValue;
        }

        public <T> T propAsOptionValue(Function<String, T> valueOf, T defaultValue) {
            try {
                return valueOf.apply(this.toUpper(this.properties.get("option")));
            }
            catch (Throwable t) {
                try {
                    return valueOf.apply(this.properties.get("option").toUpperCase());
                }
                catch (Throwable t2) {
                    return defaultValue;
                }
            }
        }

        @Nullable
        private String toUpper(String value) {
            return value != null && value.length() > 1 ? value.substring(0, 1).toUpperCase() + value.substring(1) : null;
        }
    }

    private static class LoadedConfiguration {
        private final Map<String, Module> modulesByName;
        private final FilterSet suppressions;

        public LoadedConfiguration(Collection<Module> modules, FilterSet suppressions) {
            this.modulesByName = modules.stream().collect(Collectors.toMap(Module::getName, Function.identity()));
            this.suppressions = suppressions;
        }
    }
}

