/*
 * Decompiled with CFR 0.152.
 */
package spold2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXB;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import spold2.DataSet;
import spold2.ImpactMethod;

@XmlRootElement(name="ecoSpold")
public class EcoSpold2 {
    @XmlElement(name="activityDataset")
    public DataSet dataSet;
    @XmlElement(name="childActivityDataset")
    public DataSet childDataSet;
    @XmlElement(name="impactMethod")
    public ImpactMethod impactMethod;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EcoSpold2 read(File file) {
        try (FileInputStream stream = new FileInputStream(file);){
            EcoSpold2 ecoSpold2 = EcoSpold2.read(stream);
            return ecoSpold2;
        }
        catch (Exception e) {
            String m = "failed to read EcoSpold 2 file: " + file;
            throw new RuntimeException(m, e);
        }
    }

    public static EcoSpold2 read(InputStream is) {
        try {
            return (EcoSpold2)JAXB.unmarshal((InputStream)is, EcoSpold2.class);
        }
        catch (Exception e) {
            String m = "failed to read EcoSpold 2 document";
            throw new RuntimeException(m, e);
        }
    }

    public static void write(DataSet dataSet, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            EcoSpold2.write(dataSet, fos);
        }
        catch (Exception e) {
            String m = "failed to write data set to file: " + file;
            throw new RuntimeException(m, e);
        }
    }

    public static void write(DataSet dataSet, OutputStream out) {
        try {
            EcoSpold2 spold2 = new EcoSpold2();
            spold2.dataSet = dataSet;
            JAXB.marshal((Object)spold2, (OutputStream)out);
        }
        catch (Exception e) {
            String m = "failed to write data set";
            throw new RuntimeException(m, e);
        }
    }

    public DataSet activity() {
        return this.dataSet != null ? this.dataSet : this.childDataSet;
    }
}

