/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.repository.factories;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeTypeManager;
import javax.naming.NamingException;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.loaders.jdbc.configuration.JdbcStringBasedCacheStoreConfigurationBuilder;
import org.infinispan.schematic.document.ParsingException;
import org.infinispan.transaction.TransactionMode;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.Environment;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.LocalEnvironment;
import org.modeshape.jcr.RepositoryConfiguration;
import org.openl.rules.repository.api.Listener;
import org.openl.rules.repository.exceptions.RRepositoryException;
import org.openl.rules.repository.factories.AbstractJcrRepositoryFactory;
import org.openl.util.IOUtils;
import org.openl.util.StringUtils;
import org.openl.util.db.JDBCDriverRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DBRepositoryFactory
extends AbstractJcrRepositoryFactory {
    private final Logger log = LoggerFactory.getLogger(DBRepositoryFactory.class);
    private static final String OPENL_JCR_REPO_ID_KEY = "openl-jcr-repo-id";
    private long initializeTime = 15000L;
    private long finalizeTime = 10000L;
    private ModeshapeJcrRepo repo;

    DBRepositoryFactory() {
    }

    public void setInitializeTime(long initializeTime) {
        this.initializeTime = initializeTime;
    }

    public void setFinalizeTime(long finalizeTime) {
        this.finalizeTime = finalizeTime;
    }

    private void init() throws Exception {
        JDBCDriverRegister.registerDrivers();
        String dbUrl = this.uri;
        String user = this.login;
        String pwd = this.password;
        this.log.info("Checking a connection to DB [{}]", (Object)dbUrl);
        Connection conn = this.createConnection(dbUrl, user, pwd);
        DatabaseMetaData metaData = conn.getMetaData();
        String databaseName = metaData.getDatabaseProductName().toLowerCase().replace(" ", "_");
        CompositeConfiguration properties = this.getConfiguration(databaseName);
        Case namesCase = this.getCase(metaData);
        this.log.info("Preparing a repository...");
        this.initTable(conn, properties);
        String repoID = this.getRepoID(conn, properties);
        conn.close();
        this.log.info("The repository for ID=[{}] has been prepared", (Object)repoID);
        RepositoryConfiguration config = this.getModeshapeConfiguration(dbUrl, user, pwd, repoID, properties, namesCase);
        this.log.info("Checking ModeShape configuration...");
        this.repo = new ModeshapeJcrRepo(config);
        String repoName = config.getName();
        this.log.info("Starting ModeShape repository [{}]...", (Object)repoName);
        Problems repoProblems = this.repo.getStartupProblems();
        if (repoProblems.hasErrors()) {
            this.log.error("ModeShape repository ID=[{}] has errors: ", (Object)repoProblems);
        }
        this.log.info("ModeShape repository ID=[{}] has been started", (Object)repoName);
        this.log.info("Checking the repository...");
        this.setRepository((Repository)this.repo);
    }

    abstract Connection createConnection(String var1, String var2, String var3);

    private RepositoryConfiguration getModeshapeConfiguration(String url, String user, String password, final String repoName, CompositeConfiguration properties, Case namesCase) throws SQLException, ParsingException, FileNotFoundException, NamingException {
        LocalEnvironment environment = new LocalEnvironment(){

            protected GlobalConfigurationBuilder createGlobalConfigurationBuilder() {
                GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
                global.globalJmxStatistics().enable().allowDuplicateDomains(Boolean.valueOf(true));
                global.transport().defaultTransport().clusterName(repoName);
                global.transport().addProperty("configurationFile", "openl-jgroups-mosh-config.xml");
                return global;
            }
        };
        Configuration ispnConfig = this.getInfinispanConfiguration(url, user, password, properties, namesCase);
        String tableName = this.changeCase(namesCase, properties.getString("table.name"));
        environment.defineCache(tableName, ispnConfig);
        RepositoryConfiguration config = RepositoryConfiguration.read((String)("{'name':'" + repoName + "', 'jndiName':'', 'storage':{'cacheName':'" + tableName + "','binaryStorage':{'type':'cache','dataCacheName':'" + tableName + "','metadataCacheName':'" + tableName + "'}},'clustering':{'clusterName':'" + repoName + "', 'channelConfiguration':'openl-jgroups-insp-config.xml'}}"));
        config = config.with((Environment)environment);
        Problems problems = config.validate();
        if (problems.hasErrors()) {
            String message = "Problems in the Modeshape configuration";
            this.log.error(message);
            this.log.error(problems.toString());
            throw new IllegalArgumentException(message);
        }
        return config;
    }

    private Configuration getInfinispanConfiguration(String url, String user, String password, CompositeConfiguration properties, Case namesCase) throws SQLException, NamingException {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        JdbcStringBasedCacheStoreConfigurationBuilder jdbcBuilder = (JdbcStringBasedCacheStoreConfigurationBuilder)configurationBuilder.jmxStatistics().enable().clustering().cacheMode(CacheMode.REPL_SYNC).loaders().shared(true).addLoader(JdbcStringBasedCacheStoreConfigurationBuilder.class);
        this.buildDBConnection(jdbcBuilder, url, user, password);
        ((JdbcStringBasedCacheStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedCacheStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedCacheStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedCacheStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedCacheStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)jdbcBuilder.table().createOnStart(false)).tableNamePrefix(this.changeCase(namesCase, properties.getString("table.prefix")))).idColumnName(this.changeCase(namesCase, properties.getString("column.id.name")))).idColumnType(this.changeCase(namesCase, properties.getString("column.id.type")))).dataColumnName(this.changeCase(namesCase, properties.getString("column.data.name")))).timestampColumnName(this.changeCase(namesCase, properties.getString("column.time.name")));
        return configurationBuilder.build();
    }

    abstract void buildDBConnection(JdbcStringBasedCacheStoreConfigurationBuilder var1, String var2, String var3, String var4);

    public void initialize() throws RRepositoryException {
        try {
            this.init();
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception e1) {
                this.log.error(e1.getMessage(), (Throwable)e1);
            }
            throw new RRepositoryException("Failed to initialize DataBase: " + e.getMessage(), (Throwable)e);
        }
        this.log.info("Networking...");
        try {
            Thread.sleep(this.initializeTime);
        }
        catch (InterruptedException e) {
            this.log.info(e.getMessage(), (Throwable)e);
        }
        this.log.info("Configuring JCR session...");
        super.initialize();
        this.log.info("The repository has loaded");
    }

    protected Session createSession() throws RepositoryException {
        return this.repository.login("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initNodeTypes(NodeTypeManager ntm) throws RepositoryException {
        JcrNodeTypeManager ntmi = (JcrNodeTypeManager)ntm;
        try {
            InputStream is = null;
            try {
                is = ((Object)((Object)this)).getClass().getResourceAsStream("/org/openl/rules/repository/openl_nodetypes.xml");
                ntmi.registerNodeTypes(is, true);
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new RepositoryException("Failed to init NodeTypes: " + e.getMessage(), (Throwable)e);
        }
    }

    public void close() throws IOException {
        this.log.info("Closing the connection to the repository...");
        try {
            Thread.sleep(this.finalizeTime);
        }
        catch (InterruptedException e) {
            this.log.info(e.getMessage(), (Throwable)e);
        }
        try {
            super.close();
        }
        finally {
            try {
                if (this.repo != null) {
                    this.repo.shutdown();
                    this.repo = null;
                }
            }
            catch (Exception e) {
                throw new IOException("Shutdown has failed.", e);
            }
        }
        this.log.info("The connection has been closed");
    }

    private void initTable(Connection conn, CompositeConfiguration properties) throws SQLException {
        String repoTable = this.getRepoTableName(properties);
        if (this.tableExists(conn, properties)) {
            this.log.info("Table '{}' already exists", (Object)repoTable);
            return;
        }
        this.createTable(conn, properties);
        if (this.tableExists(conn, properties)) {
            this.log.info("Table '{}' has been created", (Object)repoTable);
            return;
        }
        throw new IllegalStateException("Table '" + repoTable + "' has not created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(Connection connection, CompositeConfiguration properties) {
        ResultSet rs = null;
        String repoTable = this.getRepoTableName(properties);
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            repoTable = this.changeCase(this.getCase(metaData), repoTable);
            rs = "Oracle".equals(metaData.getDatabaseProductName()) ? metaData.getTables(null, metaData.getUserName(), repoTable, new String[]{"TABLE"}) : metaData.getTables(null, null, repoTable, new String[]{"TABLE"});
            boolean bl = rs.next();
            this.safeClose(rs);
            return bl;
        }
        catch (SQLException e) {
            this.log.debug("SQLException occurs while checking the table {}", (Object)repoTable, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.safeClose(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Connection conn, CompositeConfiguration properties) throws SQLException {
        String sql = properties.getString("sql.create-table");
        this.log.info("The following SQL script being used [ {} ]", (Object)sql);
        Statement statement = null;
        try {
            statement = conn.createStatement();
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.log.warn("SQLException occurs while checking the table {}", (Object)this.getRepoTableName(properties), (Object)e);
        }
        finally {
            this.safeClose(statement);
        }
    }

    private String getRepoID(Connection conn, CompositeConfiguration properties) throws SQLException {
        String repoID = this.selectRepoID(conn, properties);
        if (repoID != null) {
            return repoID;
        }
        this.createRepoID(conn, properties);
        repoID = this.selectRepoID(conn, properties);
        if (repoID != null) {
            return repoID;
        }
        throw new IllegalStateException("The row with ID = 'openl-jcr-repo-id' has not created");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selectRepoID(Connection conn, CompositeConfiguration properties) throws SQLException {
        ResultSet rs;
        PreparedStatement statement;
        block5: {
            statement = null;
            rs = null;
            statement = conn.prepareStatement(properties.getString("sql.select-id"));
            statement.setString(1, OPENL_JCR_REPO_ID_KEY);
            rs = statement.executeQuery();
            if (!rs.next()) break block5;
            InputStream binaryStream = rs.getBinaryStream(1);
            String string = IOUtils.toStringAndClose((InputStream)binaryStream);
            this.safeClose(rs);
            this.safeClose(statement);
            return string;
        }
        try {
            String binaryStream = null;
            this.safeClose(rs);
            this.safeClose(statement);
            return binaryStream;
        }
        catch (IOException e) {
            try {
                this.log.error("Unexpected IO failure", (Throwable)e);
                String string = null;
                this.safeClose(rs);
                this.safeClose(statement);
                return string;
            }
            catch (Throwable throwable) {
                this.safeClose(rs);
                this.safeClose(statement);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRepoID(Connection conn, CompositeConfiguration properties) throws SQLException {
        String repoId = "openl-jcr-repo-" + UUID.randomUUID().toString();
        PreparedStatement statement = null;
        try {
            statement = conn.prepareStatement(properties.getString("sql.insert-id"));
            statement.setString(1, OPENL_JCR_REPO_ID_KEY);
            statement.setBytes(2, StringUtils.toBytes((CharSequence)repoId));
            statement.executeUpdate();
            this.safeClose(statement);
        }
        catch (Throwable throwable) {
            this.safeClose(statement);
            throw throwable;
        }
    }

    private void safeClose(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                this.log.warn("Unexpected sql failure", (Throwable)e);
            }
        }
    }

    private void safeClose(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException e) {
                this.log.warn("Unexpected sql failure", (Throwable)e);
            }
        }
    }

    private CompositeConfiguration getConfiguration(String databaseName) {
        CompositeConfiguration compositeConfiguration = new CompositeConfiguration();
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.setDelimiterParsingDisabled(true);
        configuration.setFileName("modeshape-" + databaseName + ".properties");
        try {
            configuration.load();
            compositeConfiguration.addConfiguration((org.apache.commons.configuration.Configuration)configuration);
        }
        catch (ConfigurationException e) {
            this.log.debug("Configuration: {} file is absent", (Object)("modeshape-" + databaseName + ".properties"), (Object)e);
        }
        configuration = new PropertiesConfiguration();
        configuration.setDelimiterParsingDisabled(true);
        configuration.setFileName("modeshape.properties");
        try {
            configuration.load();
        }
        catch (ConfigurationException e) {
            this.log.error("Error when initializing configuration: {}", (Object)"modeshape.properties", (Object)e);
        }
        compositeConfiguration.addConfiguration((org.apache.commons.configuration.Configuration)configuration);
        return compositeConfiguration;
    }

    private String getRepoTableName(CompositeConfiguration configuration) {
        return configuration.getString("table.prefix") + "_" + configuration.getString("table.name");
    }

    private String changeCase(Case namesCase, String name) throws SQLException {
        switch (namesCase) {
            case LOWER: {
                return name.toLowerCase();
            }
            case UPPER: {
                return name.toUpperCase();
            }
        }
        return name;
    }

    private Case getCase(DatabaseMetaData metaData) throws SQLException {
        return metaData.storesLowerCaseIdentifiers() ? Case.LOWER : (metaData.storesUpperCaseIdentifiers() ? Case.UPPER : Case.MIXED);
    }

    public void setListener(Listener callback) {
        if (callback == null) {
            super.setListener(null);
        } else {
            super.setListener((Listener)new MultiAttemptListenerWrapper(callback));
        }
    }

    private static class MultiAttemptListenerWrapper
    implements Listener {
        private final Logger log = LoggerFactory.getLogger(MultiAttemptListenerWrapper.class);
        private final Listener listener;

        public MultiAttemptListenerWrapper(Listener listener) {
            this.listener = listener;
        }

        public synchronized void onChange() {
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){
                int count = 0;

                @Override
                public void run() {
                    block2: {
                        try {
                            MultiAttemptListenerWrapper.this.log.info("Atempt # {}", (Object)this.count);
                            System.gc();
                            MultiAttemptListenerWrapper.this.listener.onChange();
                            timer.cancel();
                        }
                        catch (Exception ex) {
                            MultiAttemptListenerWrapper.this.log.error("Unexpected error", (Throwable)ex);
                            ++this.count;
                            if (this.count < 5) break block2;
                            timer.cancel();
                        }
                    }
                }
            }, 3000L, 5000L);
        }
    }

    private static enum Case {
        UPPER,
        LOWER,
        MIXED;

    }

    private static class ModeshapeJcrRepo
    extends JcrRepository {
        private ModeshapeJcrRepo(RepositoryConfiguration configuration) {
            super(configuration);
        }

        private void shutdown() {
            this.doShutdown();
        }
    }
}

