/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.science;

import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Vector;
import org.openl.types.science.DimensionPower;
import org.openl.types.science.IDimensionPower;
import org.openl.types.science.IMeasurementSystem;
import org.openl.types.science.IMultiplicativeExpression;
import org.openl.types.science.MeasurementSystem;
import org.openl.types.science.MultiDimensionalExpression;
import org.openl.types.science.ScalarExpression;

public abstract class AMultiplicativeExpression
implements IMultiplicativeExpression {
    static IMultiplicativeExpression additiveOp(IMultiplicativeExpression m1, IMultiplicativeExpression m2, int sign) {
        if (!AMultiplicativeExpression.isAdditiveCompatible(m1, m2)) {
            throw new RuntimeException("" + m1 + " and " + m2 + " have different dimensions");
        }
        return m1.changeScalar(m1.getScalar() + (double)sign * m2.getScalar());
    }

    public static boolean isAdditiveCompatible(IMultiplicativeExpression m1, IMultiplicativeExpression m2) {
        if (m1.getDimensionCount() != m2.getDimensionCount()) {
            return false;
        }
        Iterator it = m1.getDimensionsPowers();
        while (it.hasNext()) {
            IDimensionPower d1 = (IDimensionPower)it.next();
            IDimensionPower d2 = m2.getDimensionPower(d1.getDimension());
            if (d2 != null && d1.getPower() == d2.getPower()) continue;
            return false;
        }
        return true;
    }

    static IMultiplicativeExpression merge(IMultiplicativeExpression m1, IMultiplicativeExpression m2, boolean multiply) {
        double newScalar;
        Vector<IDimensionPower> res = new Vector<IDimensionPower>();
        Iterator it = m1.getDimensionsPowers();
        while (it.hasNext()) {
            IDimensionPower d1 = (IDimensionPower)it.next();
            IDimensionPower d2 = m2.getDimensionPower(d1.getDimension());
            if (d2 == null) {
                res.add(d1);
                continue;
            }
            int newPower = d1.getPower() + (multiply ? d2.getPower() : -d2.getPower());
            if (newPower == 0) continue;
            res.add(new DimensionPower(d1.getDimension(), newPower));
        }
        Iterator it2 = m2.getDimensionsPowers();
        while (it2.hasNext()) {
            IDimensionPower d2 = (IDimensionPower)it2.next();
            IDimensionPower d1 = m1.getDimensionPower(d2.getDimension());
            if (d1 != null) continue;
            res.add(multiply ? d2 : AMultiplicativeExpression.negative(d2));
        }
        double d = newScalar = multiply ? m1.getScalar() * m2.getScalar() : m1.getScalar() / m2.getScalar();
        if (res.size() == 0) {
            return new ScalarExpression(newScalar);
        }
        return new MultiDimensionalExpression(newScalar, res.toArray(new IDimensionPower[res.size()]));
    }

    static IDimensionPower negative(IDimensionPower dp) {
        return new DimensionPower(dp.getDimension(), -dp.getPower());
    }

    public static String print(IMultiplicativeExpression me, IMultiplicativeExpression asUnit, String unitImage, int doubleDidgits) {
        if (!AMultiplicativeExpression.isAdditiveCompatible(me, asUnit)) {
            throw new RuntimeException("Bad unit for printing");
        }
        IMultiplicativeExpression ie = me.divide(asUnit);
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(doubleDidgits);
        return format.format(ie.getScalar()) + unitImage;
    }

    public IMultiplicativeExpression add(IMultiplicativeExpression im) throws RuntimeException {
        return AMultiplicativeExpression.additiveOp(this, im, 1);
    }

    public IMultiplicativeExpression divide(IMultiplicativeExpression im) {
        return AMultiplicativeExpression.merge(this, im, false);
    }

    public IMultiplicativeExpression multiply(IMultiplicativeExpression im) {
        return AMultiplicativeExpression.merge(this, im, true);
    }

    public IMultiplicativeExpression negate() {
        return this.changeScalar(-this.getScalar());
    }

    public String printAs(IMultiplicativeExpression asUnit, String image) {
        return AMultiplicativeExpression.print(this, asUnit, image, 2);
    }

    public String printAs(IMultiplicativeExpression asUnit, String image, int doubleDidgits) {
        return AMultiplicativeExpression.print(this, asUnit, image, doubleDidgits);
    }

    public String printInSystem(IMeasurementSystem system, int doubleDigits) {
        return system.printExpression(this, doubleDigits);
    }

    public IMultiplicativeExpression subtract(IMultiplicativeExpression im) throws RuntimeException {
        return AMultiplicativeExpression.additiveOp(this, im, -1);
    }

    public String toString() {
        return this.printInSystem(MeasurementSystem.METRIC, 2);
    }
}

