/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.science;

import org.openl.types.science.AMultiplicativeExpression;
import org.openl.types.science.Dimension;
import org.openl.types.science.DistanceUnit;
import org.openl.types.science.IBasicConstants;
import org.openl.types.science.IDimension;
import org.openl.types.science.IDimensionPower;
import org.openl.types.science.IMeasurementSystem;
import org.openl.types.science.IMultiplicativeExpression;
import org.openl.types.science.IUnit;
import org.openl.types.science.MassUnit;
import org.openl.types.science.ScalarExpression;
import org.openl.types.science.TimeUnit;

public class MeasurementSystem
implements IMeasurementSystem,
IBasicConstants {
    public static final MeasurementSystem METRIC = new MetricSystem();
    private String name;
    private MassUnit baseMassUnit;
    private DistanceUnit baseDistanceUnit;
    private TimeUnit baseTimeUnit;
    private MassUnit[] massUnits;
    private DistanceUnit[] distanceUnits;
    private TimeUnit[] timeUnits;

    public MeasurementSystem(String name, MassUnit baseMassUnit, DistanceUnit baseDistanceUnit, TimeUnit baseTimeUnit, MassUnit[] massUnits, DistanceUnit[] distanceUnits, TimeUnit[] timeUnits) {
        this.name = name;
        this.baseMassUnit = baseMassUnit;
        this.baseDistanceUnit = baseDistanceUnit;
        this.baseTimeUnit = baseTimeUnit;
        this.massUnits = massUnits;
        this.timeUnits = timeUnits;
        this.distanceUnits = distanceUnits;
    }

    public DistanceUnit getBaseDistanceUnit() {
        return this.baseDistanceUnit;
    }

    public MassUnit getBaseMassUnit() {
        return this.baseMassUnit;
    }

    public TimeUnit getBaseTimeUnit() {
        return this.baseTimeUnit;
    }

    public String getDisplayName(int mode) {
        return this.name;
    }

    public DistanceUnit[] getDistanceUnits() {
        return this.distanceUnits;
    }

    public MassUnit[] getMassUnits() {
        return this.massUnits;
    }

    public String getName() {
        return this.name;
    }

    public TimeUnit[] getTimeUnits() {
        return this.timeUnits;
    }

    public String printExpression(IMultiplicativeExpression im, int doubleDigits) {
        int p;
        int i;
        IDimension[] supportedDimensions = new IDimension[]{Dimension.DISTANCE, Dimension.TIME, Dimension.MASS};
        IUnit[] baseUnits = new IUnit[]{this.baseDistanceUnit, this.baseTimeUnit, this.baseMassUnit};
        int dimCount = 0;
        int negCount = 0;
        int posCount = 0;
        IDimensionPower[] powers = new IDimensionPower[supportedDimensions.length];
        IMultiplicativeExpression expr = new ScalarExpression(1.0);
        for (int i2 = 0; i2 < supportedDimensions.length; ++i2) {
            int j;
            IDimensionPower dp = im.getDimensionPower(supportedDimensions[i2]);
            if (dp == null) continue;
            ++dimCount;
            if (dp.getPower() < 0) {
                ++negCount;
                for (j = 0; j < Math.abs(dp.getPower()); ++j) {
                    expr = expr.divide(baseUnits[i2]);
                }
            } else {
                ++posCount;
                for (j = 0; j < dp.getPower(); ++j) {
                    expr = expr.multiply(baseUnits[i2]);
                }
            }
            powers[i2] = dp;
        }
        if (dimCount == 0) {
            return AMultiplicativeExpression.print(im, expr, "", doubleDigits);
        }
        StringBuffer buf = new StringBuffer();
        if (posCount == 0) {
            buf.append("1");
        } else {
            boolean printed = false;
            for (i = 0; i < powers.length; ++i) {
                if (powers[i] == null || (p = powers[i].getPower()) <= 0) continue;
                if (printed) {
                    buf.append('*');
                }
                printed = true;
                buf.append(baseUnits[i].getName());
                if (p <= 1) continue;
                buf.append("^" + p);
            }
        }
        if (negCount != 0) {
            buf.append('/');
            boolean printed = false;
            for (i = 0; i < powers.length; ++i) {
                if (powers[i] == null || (p = powers[i].getPower()) >= 0) continue;
                if (printed) {
                    buf.append('*');
                }
                printed = true;
                buf.append(baseUnits[i].getName());
                if (p <= 1) continue;
                buf.append("^" + -p);
            }
        }
        return AMultiplicativeExpression.print(im, expr, buf.toString(), doubleDigits);
    }

    static class MetricSystem
    extends MeasurementSystem {
        public MetricSystem() {
            super("metric", kg, M, S, new MassUnit[]{t, kg, g, mg}, new DistanceUnit[]{KM, M, CM, MM}, new TimeUnit[]{WEEK, DAY, H, MIN, S, MS, MKS});
        }
    }
}

