/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.science;

import java.util.Collections;
import org.openl.base.INamedThing;
import org.openl.types.science.AMultiplicativeExpression;
import org.openl.types.science.IDimension;
import org.openl.types.science.IDimensionPower;
import org.openl.types.science.IUnit;

public abstract class ASimpleUnit
extends AMultiplicativeExpression
implements IUnit,
IDimensionPower,
INamedThing {
    IDimension dimension;
    String name;

    protected ASimpleUnit(String name, IDimension dimension) {
        this.name = name;
        this.dimension = dimension;
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    @Override
    public int getDimensionCount() {
        return 1;
    }

    @Override
    public IDimensionPower getDimensionPower(IDimension id) {
        return id == this.dimension ? this : null;
    }

    @Override
    public Iterable<IDimensionPower> getDimensionsPowers() {
        return Collections.singletonList(this);
    }

    public String getDisplayName(int mode) {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPower() {
        return 1;
    }

    @Override
    public double getScalar() {
        return this.normalize(1.0);
    }

    public abstract double normalize(double var1);
}

