/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.science;

import java.util.Collections;
import org.openl.types.science.AMultiplicativeExpression;
import org.openl.types.science.IDimension;
import org.openl.types.science.IDimensionPower;
import org.openl.types.science.IMultiplicativeExpression;

public class OneDimensionalExpression
extends AMultiplicativeExpression
implements IDimensionPower {
    double scalar;
    IDimension dimension;

    public OneDimensionalExpression(double scalar, IDimension dimension) {
        this.scalar = scalar;
        this.dimension = dimension;
    }

    @Override
    public IMultiplicativeExpression changeScalar(double newScalar) {
        return new OneDimensionalExpression(newScalar, this.dimension);
    }

    @Override
    public IDimension getDimension() {
        return this.dimension;
    }

    @Override
    public int getDimensionCount() {
        return 1;
    }

    @Override
    public IDimensionPower getDimensionPower(IDimension id) {
        return id == this.dimension ? this : null;
    }

    @Override
    public Iterable<IDimensionPower> getDimensionsPowers() {
        return Collections.singletonList(this);
    }

    @Override
    public int getPower() {
        return 1;
    }

    @Override
    public double getScalar() {
        return this.scalar;
    }
}

