/*
 * Decompiled with CFR 0.152.
 */
package org.openl.types.science;

import java.util.Iterator;
import org.openl.types.science.AMultiplicativeExpression;
import org.openl.types.science.IDimension;
import org.openl.types.science.IDimensionPower;
import org.openl.types.science.IMultiplicativeExpression;
import org.openl.util.OpenIterator;

public class MultiDimensionalExpression
extends AMultiplicativeExpression {
    double scalar;
    IDimensionPower[] power;

    public MultiDimensionalExpression(double scalar, IDimensionPower[] power) {
        this.scalar = scalar;
        this.power = power;
    }

    @Override
    public IMultiplicativeExpression changeScalar(double newScalar) {
        if (newScalar == this.scalar) {
            return this;
        }
        return new MultiDimensionalExpression(newScalar, this.power);
    }

    @Override
    public int getDimensionCount() {
        return this.power.length;
    }

    @Override
    public IDimensionPower getDimensionPower(IDimension id) {
        for (int i = 0; i < this.power.length; ++i) {
            if (this.power[i].getDimension() != id) continue;
            return this.power[i];
        }
        return null;
    }

    @Override
    public Iterator getDimensionsPowers() {
        return OpenIterator.fromArray((Object[])this.power);
    }

    @Override
    public double getScalar() {
        return this.scalar;
    }
}

