/*
 * Decompiled with CFR 0.152.
 */
package org.openl.grammar;

import org.openl.util.text.IPosition;
import org.openl.util.text.TextInfo;

public class JavaCC30Position
implements IPosition {
    private static final int JAVACC30_TABSIZE = 8;
    private final int jcc30line;
    private final int jcc30col;

    public JavaCC30Position(int jcc30line, int jcc30col) {
        this.jcc30col = jcc30col;
        this.jcc30line = jcc30line;
    }

    public int getAbsolutePosition(TextInfo info) {
        if (this.jcc30line == 0) {
            return 0;
        }
        int line = this.jcc30line - 1;
        int linePos = info.getPosition(line);
        int colPos = TextInfo.getPosition((String)info.getLine(line), (int)(this.jcc30col - 1), (int)8);
        return linePos + colPos;
    }

    public int getColumn(TextInfo info, int tabSize) {
        if (this.jcc30line == 0) {
            return 0;
        }
        int line = this.jcc30line - 1;
        int colPos = TextInfo.getPosition((String)info.getLine(line), (int)(this.jcc30col - 1), (int)8);
        return TextInfo.getColumn((String)info.getLine(line), (int)colPos, (int)tabSize);
    }

    public int getLine(TextInfo info) {
        return this.jcc30line - 1;
    }

    public String toString() {
        return "(" + this.jcc30line + "," + this.jcc30col + ")";
    }
}

