/*
 * Decompiled with CFR 0.152.
 */
package org.openl.grammar;

public class ParserErrorMessage {
    public static final String UNEXPECTED_SYMBOL = "Unexpected symbol '%s' after token <%s>";
    public static final String UNEXPECTED_BRACKET = "Unexpected bracket '%s'";
    public static final String UNMATCHED_BRACKET = "Need to close '%s'";
    public static final String MISMATCHED_BRACKET = "Mismatched: opened with '%s' and closed with '%s'";
    public static final String NEED_TO_CLOSE = "Need to close <%s> with <%s>";

    public static String printUnexpectedSymbolAfter(String token, char c) {
        return String.format(UNEXPECTED_SYMBOL, ParserErrorMessage.addEscapes(new String(new char[]{c})), ParserErrorMessage.addEscapes(token));
    }

    public static String printNeedToClose(String token, char c) {
        return String.format(NEED_TO_CLOSE, ParserErrorMessage.addEscapes(token), ParserErrorMessage.addEscapes(new String(new char[]{c})));
    }

    public static String printUnexpectedBracket(String image) {
        return String.format(UNEXPECTED_BRACKET, ParserErrorMessage.addEscapes(image));
    }

    public static String printUmatchedBracket(String image) {
        return String.format(UNMATCHED_BRACKET, ParserErrorMessage.addEscapes(image));
    }

    public static String printMismatchedBracket(String first, String second) {
        return String.format(MISMATCHED_BRACKET, ParserErrorMessage.addEscapes(first), ParserErrorMessage.addEscapes(second));
    }

    public static void main(String[] args) {
        System.out.println(ParserErrorMessage.printUnexpectedSymbolAfter("\"aaaz", '\n'));
        System.out.println(ParserErrorMessage.printUnexpectedSymbolAfter("\"aaaz", '\u04d2'));
        System.out.println(ParserErrorMessage.printUnexpectedSymbolAfter("\"aaaz", '~'));
    }

    public static final String addEscapes(String str) {
        StringBuffer retval = new StringBuffer();
        block8: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block8;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block8;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block8;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block8;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block8;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block8;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block8;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

