/*
 * Decompiled with CFR 0.152.
 */
package org.openl.grammar;

import org.openl.grammar.ParserErrorMessage;

public class BaseTokenMgrError
extends Error {
    boolean eOFSeen;
    int lexState;
    int errorLine;
    int errorColumn;
    String errorAfter;
    char curChar;
    int reason;

    public BaseTokenMgrError(String message) {
        super(message);
    }

    public BaseTokenMgrError() {
    }

    public BaseTokenMgrError(boolean eOFSeen, int lexState, int errorLine, int errorColumn, String errorAfter, char curChar, int reason, String lexicalError) {
        super(lexicalError);
        this.eOFSeen = eOFSeen;
        this.lexState = lexState;
        this.errorLine = errorLine;
        this.errorColumn = errorColumn;
        this.errorAfter = errorAfter;
        this.curChar = curChar;
        this.reason = reason;
    }

    public int getStartLine() {
        return this.errorLine;
    }

    public int getEndLine() {
        return this.errorLine;
    }

    public int getEndCol() {
        return this.eOFSeen ? this.errorColumn : this.errorColumn + 1;
    }

    public int getStartCol() {
        int len = this.errorAfter == null ? 0 : this.errorAfter.length();
        return this.errorColumn > 0 ? this.errorColumn - Math.min(len, this.errorColumn - 1) : 0;
    }

    @Override
    public String getMessage() {
        if (this.errorAfter == null || this.errorAfter.length() == 0) {
            return super.getMessage();
        }
        char c = this.errorAfter.charAt(0);
        if (!this.eOFSeen) {
            return ParserErrorMessage.printUnexpectedSymbolAfter(this.errorAfter, this.curChar);
        }
        switch (c) {
            case '\"': 
            case '\'': {
                return ParserErrorMessage.printNeedToClose(this.errorAfter, c);
            }
        }
        return super.getMessage();
    }
}

