/*
 * Decompiled with CFR 0.152.
 */
package org.openl.grammar.bexgrammar;

import org.openl.grammar.BracketMatcher;
import org.openl.grammar.ParserErrorMessage;
import org.openl.grammar.bexgrammar.BExGrammar;
import org.openl.grammar.bexgrammar.ParseException;
import org.openl.grammar.bexgrammar.Token;
import org.openl.grammar.bexgrammar.TokenMgrError;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.util.text.ILocation;
import org.openl.util.text.TextInterval;

public class BExGrammarWithParsingHelp
extends BExGrammar {
    @Override
    public void parseTopNode(String type) {
        try {
            if (type.equals("method.body")) {
                this.parseTopNodeInternal();
            } else if (type.equals("method.header")) {
                this.MethodHeader();
            } else if (type.equals("module")) {
                this.parseModuleInternal();
            } else if (type.equals("type")) {
                this.Type();
            } else if (type.equals("range.literal.real")) {
                this.RangeLiteralFloat();
            } else if (type.equals("range.literal")) {
                this.RangeLiteral();
            }
        }
        catch (ParseException pe) {
            SyntaxNodeException sne = this.reparseTokens(pe);
            if (sne == null) {
                sne = new SyntaxNodeException(pe.getMessage(), null, (ILocation)this.pos(pe.currentToken), this.syntaxBuilder.getModule());
            }
            this.syntaxBuilder.addError(sne);
        }
        catch (TokenMgrError err) {
            TextInterval loc = new TextInterval(this.pos(err.getStartLine(), err.getStartCol()), this.pos(err.getEndLine(), err.getEndCol()));
            this.syntaxBuilder.addError(new SyntaxNodeException(err.getMessage(), null, (ILocation)loc, this.syntaxBuilder.getModule()));
        }
        catch (Exception e) {
            this.syntaxBuilder.addError(new SyntaxNodeException("", (Throwable)e, (ILocation)this.pos(this.token), this.syntaxBuilder.getModule()));
        }
        catch (Throwable t) {
            this.syntaxBuilder.addError(new SyntaxNodeException("", t, (ILocation)this.pos(this.token), this.syntaxBuilder.getModule()));
        }
    }

    private SyntaxNodeException reparseTokens(ParseException pe) {
        BracketMatcher bm;
        block4: {
            Token t;
            BracketMatcher.BracketsStackObject bso;
            BExGrammar be = new BExGrammar();
            be.setModule(this.syntaxBuilder.getModule());
            be.ReInit(this.syntaxBuilder.getModule().getCharacterStream());
            bm = new BracketMatcher();
            do {
                t = be.getNextToken();
                if (t.kind == 0) break block4;
            } while ((bso = bm.addToken(t.image, t)) == null);
            if (bso.getErrorCode() == "Unexpected") {
                String message = ParserErrorMessage.printUnexpectedBracket(t.image);
                return new SyntaxNodeException(message, null, (ILocation)this.pos(t), this.syntaxBuilder.getModule());
            }
            if (bso.getErrorCode() == "Mismatched") {
                Token t2 = (Token)bso.getId();
                String message = ParserErrorMessage.printMismatchedBracket(t2.image.substring(0, 1), t.image);
                return new SyntaxNodeException(message, null, (ILocation)this.pos(t2, t), this.syntaxBuilder.getModule());
            }
            throw new RuntimeException("Unknown BracketMatchError = " + bso.getErrorCode());
        }
        BracketMatcher.BracketsStackObject bso = bm.checkAtTheEnd();
        if (bso != null) {
            Token t = (Token)bso.getId();
            String message = ParserErrorMessage.printUmatchedBracket(t.image);
            return new SyntaxNodeException(message, null, (ILocation)this.pos(t), this.syntaxBuilder.getModule());
        }
        return null;
    }
}

