/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import org.openjdk.jol.datamodel.X86_32_DataModel;
import org.openjdk.jol.datamodel.X86_64_COOPS_DataModel;
import org.openjdk.jol.datamodel.X86_64_DataModel;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.operations.ClasspathedOperation;

public class ObjectEstimates
extends ClasspathedOperation {
    @Override
    public String label() {
        return "estimates";
    }

    @Override
    public String description() {
        return "Simulate the class layout in different VM modes.";
    }

    @Override
    protected void runWith(Class<?> klass) throws Exception {
        System.out.println("***** 32-bit VM: **********************************************************");
        System.out.println(ClassLayout.parseClass(klass, new HotSpotLayouter(new X86_32_DataModel())).toPrintable());
        System.out.println("***** 64-bit VM: **********************************************************");
        System.out.println(ClassLayout.parseClass(klass, new HotSpotLayouter(new X86_64_DataModel())).toPrintable());
        System.out.println("***** 64-bit VM, compressed references enabled: ***************************");
        System.out.println(ClassLayout.parseClass(klass, new HotSpotLayouter(new X86_64_COOPS_DataModel())).toPrintable());
        System.out.println("***** 64-bit VM, compressed references enabled, 16-byte align: ************");
        System.out.println(ClassLayout.parseClass(klass, new HotSpotLayouter(new X86_64_COOPS_DataModel(16))).toPrintable());
    }
}

