/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.openjdk.jol.info.GraphPathRecord;
import org.openjdk.jol.info.GraphVisitor;
import org.openjdk.jol.util.ObjectUtils;

public class GraphWalker {
    private final Set<Object> visited;
    private final Object[] roots;
    private final Collection<GraphVisitor> visitors;

    public GraphWalker(Object ... roots) {
        this.roots = roots;
        this.visited = Collections.newSetFromMap(new IdentityHashMap());
        this.visitors = new ArrayList<GraphVisitor>();
    }

    public void addVisitor(GraphVisitor v) {
        this.visitors.add(v);
    }

    public void walk() {
        ArrayList<GraphPathRecord> curLayer = new ArrayList<GraphPathRecord>();
        ArrayList<GraphPathRecord> newLayer = new ArrayList<GraphPathRecord>();
        int rootId = 1;
        boolean single = this.roots.length == 1;
        for (Object root : this.roots) {
            String label = single ? "" : "<r" + rootId + ">";
            GraphPathRecord e = new GraphPathRecord(label, 0, root);
            this.visited.add(root);
            this.visitObject(e);
            curLayer.add(e);
            ++rootId;
        }
        while (!curLayer.isEmpty()) {
            newLayer.clear();
            for (GraphPathRecord next : curLayer) {
                for (GraphPathRecord ref : this.peelReferences(next)) {
                    if (!this.visited.add(ref.obj())) continue;
                    this.visitObject(ref);
                    newLayer.add(ref);
                }
            }
            curLayer.clear();
            curLayer.addAll(newLayer);
        }
    }

    private void visitObject(GraphPathRecord record) {
        for (GraphVisitor v : this.visitors) {
            v.visit(record);
        }
    }

    private List<GraphPathRecord> peelReferences(GraphPathRecord r) {
        Object o = r.obj();
        if (o == null) {
            return Collections.emptyList();
        }
        if (o.getClass().isArray() && o.getClass().getComponentType().isPrimitive()) {
            return Collections.emptyList();
        }
        ArrayList<GraphPathRecord> result = new ArrayList<GraphPathRecord>();
        if (o.getClass().isArray()) {
            int c = 0;
            for (Object e : (Object[])o) {
                if (e != null) {
                    result.add(new GraphPathRecord(r.path() + "[" + c + "]", r.depth() + 1, e));
                }
                ++c;
            }
        } else {
            for (Field f : this.getAllReferences(o.getClass())) {
                Object e = ObjectUtils.value(o, f);
                if (e == null) continue;
                result.add(new GraphPathRecord(r.path() + "." + f.getName(), r.depth() + 1, e));
            }
        }
        return result;
    }

    private Collection<Field> getAllReferences(Class<?> klass) {
        ArrayList<Field> results = new ArrayList<Field>();
        for (Field f : klass.getDeclaredFields()) {
            if (Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive()) continue;
            results.add(f);
        }
        Class<?> superKlass = klass;
        while ((superKlass = superKlass.getSuperclass()) != null) {
            for (Field f : superKlass.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers()) || f.getType().isPrimitive()) continue;
                results.add(f);
            }
        }
        return results;
    }
}

