/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.SortedSet;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.FieldLayout;
import org.openjdk.jol.layouters.CurrentLayouter;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.util.ClassUtils;
import org.openjdk.jol.util.ObjectUtils;
import org.openjdk.jol.vm.VM;
import org.openjdk.jol.vm.VirtualMachine;

public class ClassLayout {
    private final ClassData classData;
    private final SortedSet<FieldLayout> fields;
    private final int headerSize;
    private final long size;

    public static ClassLayout parseClass(Class<?> klass) {
        return ClassLayout.parseClass(klass, new CurrentLayouter());
    }

    public static ClassLayout parseClass(Class<?> klass, Layouter layouter) {
        return layouter.layout(ClassData.parseClass(klass));
    }

    public static ClassLayout parseInstance(Object instance) {
        return ClassLayout.parseInstance(instance, new CurrentLayouter());
    }

    public static ClassLayout parseInstance(Object instance, Layouter layouter) {
        return layouter.layout(ClassData.parseInstance(instance));
    }

    public ClassLayout(ClassData classData, SortedSet<FieldLayout> fields, int headerSize, long instanceSize, boolean check) {
        this.classData = classData;
        this.fields = fields;
        this.headerSize = headerSize;
        this.size = instanceSize;
        if (check) {
            this.checkInvariants();
        }
    }

    private void checkInvariants() {
        FieldLayout lastField = null;
        for (FieldLayout f : this.fields) {
            if (f.offset() % f.size() != 0L) {
                throw new IllegalStateException("Field " + f + " is not aligned");
            }
            if (f.offset() + f.size() > this.instanceSize()) {
                throw new IllegalStateException("Field " + f + " is overflowing the object of size " + this.instanceSize());
            }
            if (lastField != null && f.offset() < lastField.offset() + lastField.size()) {
                throw new IllegalStateException("Field " + f + " overlaps with the previous field " + lastField);
            }
            lastField = f;
        }
    }

    public SortedSet<FieldLayout> fields() {
        return this.fields;
    }

    public long instanceSize() {
        return this.size;
    }

    public int headerSize() {
        return this.headerSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FieldLayout f : this.fields()) {
            sb.append(f).append("\n");
        }
        sb.append("size = ").append(this.size).append("\n");
        return sb.toString();
    }

    public String toPrintable() {
        return this.toPrintable(this.classData.instance());
    }

    public String toPrintable(Object instance) {
        long sizeOf;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String MSG_GAP = "(alignment/padding gap)";
        String MSG_NEXT_GAP = "(loss due to the next object alignment)";
        int maxTypeLen = "TYPE".length();
        for (FieldLayout fieldLayout : this.fields()) {
            maxTypeLen = Math.max(fieldLayout.typeClass().length(), maxTypeLen);
        }
        maxTypeLen += 2;
        int maxDescrLen = Math.max(MSG_GAP.length(), MSG_NEXT_GAP.length());
        for (FieldLayout f : this.fields()) {
            maxDescrLen = Math.max(f.shortFieldName().length(), maxDescrLen);
        }
        maxDescrLen += 2;
        if (instance != null) {
            try {
                Class<?> clazz = ClassUtils.loadClass(this.classData.name());
                if (!clazz.isAssignableFrom(instance.getClass())) {
                    throw new IllegalArgumentException("Passed instance type " + instance.getClass() + " is not assignable from " + clazz + ".");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException("Class is not found: " + this.classData.name() + ".");
            }
        }
        pw.println(this.classData.name() + " object internals:");
        pw.printf(" %6s %5s %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n", "OFFSET", "SIZE", "TYPE", "DESCRIPTION", "VALUE");
        if (instance != null) {
            VirtualMachine virtualMachine = VM.current();
            for (long off = 0L; off < (long)this.headerSize(); off += 4L) {
                int word = virtualMachine.getInt(instance, off);
                pw.printf(" %6d %5d %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n", off, 4, "", "(object header)", ClassLayout.toHex(word >> 0 & 0xFF) + " " + ClassLayout.toHex(word >> 8 & 0xFF) + " " + ClassLayout.toHex(word >> 16 & 0xFF) + " " + ClassLayout.toHex(word >> 24 & 0xFF) + " (" + ClassLayout.toBinary(word >> 0 & 0xFF) + " " + ClassLayout.toBinary(word >> 8 & 0xFF) + " " + ClassLayout.toBinary(word >> 16 & 0xFF) + " " + ClassLayout.toBinary(word >> 24 & 0xFF) + ") (" + word + ")");
            }
        } else {
            pw.printf(" %6d %5d %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n", 0, this.headerSize(), "", "(object header)", "N/A");
        }
        long l = this.headerSize();
        long interLoss = 0L;
        long exterLoss = 0L;
        for (FieldLayout f : this.fields()) {
            if (f.offset() > l) {
                pw.printf(" %6d %5d %" + maxTypeLen + "s %-" + maxDescrLen + "s%n", l, f.offset() - l, "", MSG_GAP);
                interLoss += f.offset() - l;
            }
            Field fi = f.data().refField();
            pw.printf(" %6d %5d %" + maxTypeLen + "s %-" + maxDescrLen + "s %s%n", f.offset(), f.size(), f.typeClass(), f.shortFieldName(), instance != null && fi != null ? ObjectUtils.safeToString(ObjectUtils.value(instance, fi)) : "N/A");
            l = f.offset() + f.size();
        }
        long l2 = sizeOf = instance != null ? VM.current().sizeOf(instance) : this.instanceSize();
        if (sizeOf != l) {
            exterLoss = sizeOf - l;
            pw.printf(" %6d %5s %" + maxTypeLen + "s %s%n", l, exterLoss, "", MSG_NEXT_GAP);
        }
        pw.printf("Instance size: %d bytes%n", sizeOf);
        pw.printf("Space losses: %d bytes internal + %d bytes external = %d bytes total%n", interLoss, exterLoss, interLoss + exterLoss);
        pw.close();
        return sw.toString();
    }

    private static String toBinary(int x) {
        String s = Integer.toBinaryString(x);
        int deficit = 8 - s.length();
        for (int c = 0; c < deficit; ++c) {
            s = "0" + s;
        }
        return s;
    }

    private static String toHex(int x) {
        String s = Integer.toHexString(x);
        int deficit = 2 - s.length();
        for (int c = 0; c < deficit; ++c) {
            s = "0" + s;
        }
        return s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLayout that = (ClassLayout)o;
        if (this.headerSize != that.headerSize) {
            return false;
        }
        if (this.size != that.size) {
            return false;
        }
        return this.fields.equals(that.fields);
    }

    public int hashCode() {
        int result = this.fields.hashCode();
        result = 31 * result + this.headerSize;
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }
}

