/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.vm.sa;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.openjdk.jol.util.ClassUtils;
import org.openjdk.jol.vm.sa.Request;
import org.openjdk.jol.vm.sa.Response;
import org.openjdk.jol.vm.sa.Result;
import org.openjdk.jol.vm.sa.Task;

class AttachMain {
    AttachMain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block21: {
            Response response = null;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectInputStream in = null;
            ObjectOutputStream out = null;
            Object hotspotAgent = null;
            Method detachMethod = null;
            try {
                in = new ObjectInputStream(System.in);
                out = new ObjectOutputStream(bos);
                System.setProperty("sun.jvm.hotspot.debugger.useProcDebugger", "true");
                System.setProperty("sun.jvm.hotspot.debugger.useWindbgDebugger", "true");
                final Request request = (Request)in.readObject();
                Class<?> hotspotAgentClass = ClassUtils.loadClass("sun.jvm.hotspot.HotSpotAgent");
                hotspotAgent = hotspotAgentClass.newInstance();
                final Method attachMethod = hotspotAgentClass.getMethod("attach", Integer.TYPE);
                detachMethod = hotspotAgentClass.getMethod("detach", new Class[0]);
                final Object agent = hotspotAgent;
                Future<Object> future = Executors.newCachedThreadPool(new MyThreadFactory()).submit(new Callable<Object>(){

                    @Override
                    public Object call() {
                        try {
                            attachMethod.invoke(agent, (int)request.getProcessId());
                            return ClassUtils.loadClass("sun.jvm.hotspot.runtime.VM").getMethod("getVM", new Class[0]).invoke(null, new Object[0]);
                        }
                        catch (Exception t) {
                            throw new RuntimeException(t);
                        }
                    }
                });
                Object vm = future.get(request.getTimeout(), TimeUnit.MILLISECONDS);
                if (vm != null) {
                    Task processor = request.getProcessor();
                    if (processor != null) {
                        Result result = processor.process();
                        response = new Response(result);
                    }
                    break block21;
                }
                throw new IllegalStateException("VM couldn't be initialized!");
            }
            catch (Throwable t) {
                response = new Response(t);
            }
            finally {
                if (out != null) {
                    try {
                        out.writeObject(response);
                        out.flush();
                        System.out.write(bos.toByteArray());
                    }
                    catch (IOException request) {}
                }
                if (hotspotAgent != null && detachMethod != null) {
                    try {
                        detachMethod.invoke(hotspotAgent, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException request) {}
                }
            }
        }
    }

    static class MyThreadFactory
    implements ThreadFactory {
        final ThreadFactory f = Executors.defaultThreadFactory();

        MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.f.newThread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

