/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.datamodel.Model32;
import org.openjdk.jol.datamodel.Model64;
import org.openjdk.jol.datamodel.Model64_CCPS;
import org.openjdk.jol.datamodel.Model64_COOPS_CCPS;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.layouters.HotSpotLayouter;
import org.openjdk.jol.operations.ClasspathedOperation;

public class ObjectEstimates
extends ClasspathedOperation {
    private static final DataModel[] MODELS_JDK8 = new DataModel[]{new Model32(), new Model64(), new Model64_COOPS_CCPS(), new Model64_COOPS_CCPS(16)};
    private static final DataModel[] MODELS_JDK15 = new DataModel[]{new Model64_CCPS(), new Model64_CCPS(16)};

    @Override
    public String label() {
        return "estimates";
    }

    @Override
    public String description() {
        return "Simulate the class layout in different VM modes.";
    }

    @Override
    protected void runWith(Class<?> klass) {
        HotSpotLayouter l;
        for (DataModel model : MODELS_JDK8) {
            l = new HotSpotLayouter(model, 8);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(klass, l).toPrintable());
        }
        for (DataModel model : MODELS_JDK8) {
            l = new HotSpotLayouter(model, 15);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(klass, l).toPrintable());
        }
        for (DataModel model : MODELS_JDK15) {
            l = new HotSpotLayouter(model, 15);
            System.out.println("***** " + l);
            System.out.println(ClassLayout.parseClass(klass, l).toPrintable());
        }
    }
}

