/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.operations;

import java.lang.reflect.Constructor;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jol.Operation;
import org.openjdk.jol.OptionFormatter;
import org.openjdk.jol.util.ClassUtils;
import org.openjdk.jol.vm.VM;

public abstract class ClasspathedOperation
implements Operation {
    @Override
    public void run(String[] args) throws Exception {
        List<String> classes;
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new OptionFormatter(this.label()));
        ArgumentAcceptingOptionSpec<String> optClassPath = parser.accepts("cp", "Additional classpath entries, where to look for the referenced classes.").withRequiredArg().ofType(String.class).describedAs("classpath").withValuesSeparatedBy(System.getProperty("path.separator"));
        NonOptionArgumentSpec<String> optClasses = parser.nonOptions("Class names to work on.");
        try {
            OptionSet set = parser.parse(args);
            classes = set.valuesOf(optClasses);
            if (classes.isEmpty()) {
                System.err.println("Need class name(s) as the arguments.");
                System.err.println();
                parser.printHelpOn(System.err);
                return;
            }
            if (set.has(optClassPath)) {
                ClassUtils.addClasspathEntries(optClassPath.values(set));
            }
        }
        catch (OptionException e) {
            parser.printHelpOn(System.err);
            return;
        }
        System.out.println(VM.current().details());
        for (String klassName : classes) {
            try {
                this.runWith(ClassUtils.loadClass(klassName));
            }
            catch (Throwable t) {
                t.printStackTrace(System.err);
            }
        }
    }

    protected Object tryInstantiate(Class<?> klass) throws Exception {
        try {
            Constructor<?> ctor = klass.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            Object o = ctor.newInstance(new Object[0]);
            System.out.println("Instantiated the sample instance via default constructor.");
            System.out.println();
            return o;
        }
        catch (Exception ctor) {
            Constructor<?>[] cnstrs;
            for (Constructor<?> ctor2 : cnstrs = klass.getDeclaredConstructors()) {
                try {
                    ctor2.setAccessible(true);
                    Class<?>[] types = ctor2.getParameterTypes();
                    Object[] args = new Object[types.length];
                    for (int c = 0; c < types.length; ++c) {
                        args[c] = ClasspathedOperation.makeDefaultValue(types[c]);
                    }
                    Object o = ctor2.newInstance(args);
                    System.out.println("Instantiated the sample instance via " + ctor2);
                    System.out.println();
                    return o;
                }
                catch (Exception exception) {
                }
            }
            throw new InstantiationException("No matching (default) constructor, and no other constructor work.");
        }
    }

    private static Object makeDefaultValue(Class<?> type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.FALSE;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)0;
        }
        if (type == Short.TYPE || type == Short.class) {
            return (short)0;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 0;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type == Long.TYPE || type == Long.class) {
            return 0L;
        }
        if (type == Double.TYPE || type == Double.class) {
            return 0.0;
        }
        return null;
    }

    protected abstract void runWith(Class<?> var1) throws Exception;
}

