/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import joptsimple.HelpFormatter;
import joptsimple.OptionDescriptor;

public class OptionFormatter
implements HelpFormatter {
    private final String label;

    public OptionFormatter(String label) {
        this.label = label;
    }

    @Override
    public String format(Map<String, ? extends OptionDescriptor> options) {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage: java -jar ... " + this.label + " [options] <classes*>");
        sb.append("\n");
        sb.append(" [opt] means optional argument.\n");
        sb.append(" <opt> means required argument.\n");
        sb.append("\n");
        for (OptionDescriptor optionDescriptor : options.values()) {
            sb.append(this.lineFor(optionDescriptor));
        }
        return sb.toString();
    }

    private Collection<String> rewrap(String lines) {
        ArrayList<String> result = new ArrayList<String>();
        String[] words = lines.split("[ \n]");
        String line = "";
        int cols = 0;
        for (String w : words) {
            line = line + w + " ";
            if ((cols += w.length()) <= 40) continue;
            result.add(line);
            line = "";
            cols = 0;
        }
        result.add(line);
        return result;
    }

    private String lineFor(OptionDescriptor d) {
        StringBuilder line = new StringBuilder();
        StringBuilder o = new StringBuilder();
        o.append("  ");
        for (String str : d.options()) {
            if (!d.representsNonOptions()) {
                o.append("-");
            }
            o.append(str);
            if (!d.acceptsArguments()) continue;
            o.append(" ");
            if (d.requiresArgument()) {
                o.append("<");
            } else {
                o.append("[");
            }
            o.append(d.argumentDescription());
            if (d.requiresArgument()) {
                o.append(">");
                continue;
            }
            o.append("]");
        }
        line.append(String.format("%-30s", o.toString()));
        boolean first = true;
        for (String l : this.rewrap(d.description())) {
            if (first) {
                first = false;
            } else {
                line.append("\n");
                line.append(String.format("%-30s", ""));
            }
            line.append(l);
        }
        line.append(System.getProperty("line.separator"));
        return line.toString();
    }
}

