/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class CompressedOopsRule
implements IRule {
    private static final String RESULT_ID = "CompressedOops";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.BooleanFlag", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.UnsignedLongFlag", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.JVMInformation", RulesToolkit.EventAvailability.AVAILABLE).build();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        Boolean compressedOops = (Boolean)items.getAggregate(Aggregators.or((String)"jdk.GCHeapConfiguration", (IAttribute)JdkAttributes.HEAP_USE_COMPRESSED_OOPS));
        IQuantity mx = (IQuantity)items.getAggregate(JdkAggregators.LARGEST_MAX_HEAP_SIZE_FROM_FLAG);
        String vmName = (String)items.getAggregate(JdkAggregators.JVM_NAME);
        if (compressedOops != null && mx != null && vmName != null && vmName.toUpperCase().contains("64-BIT") && mx.compareTo((Object)UnitLookup.NUMBER.getUnit((IPrefix)BinaryPrefix.GIBI).quantity(32L)) > 0 && !compressedOops.booleanValue()) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("CompressedOopsRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("CompressedOopsRuleFactory_TEXT_INFO_LONG")).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("CompressedOopsRuleFactory_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return CompressedOopsRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("CompressedOopsRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "gc_configuration";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return Collections.emptyList();
    }
}

