/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.FutureTask;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.StringToolkit;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.HaltsProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class ApplicationHaltsRule
extends AbstractRule {
    public static final TypedPreference<IQuantity> APP_HALTS_INFO_LIMIT = new TypedPreference("app.halts.info.limit", Messages.getString("ApplicationHaltsRule_HALTS_INFO_LIMIT"), Messages.getString("ApplicationHaltsRule_HALTS_INFO_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(5L));
    public static final TypedPreference<IQuantity> APP_HALTS_WARNING_LIMIT = new TypedPreference("app.halts.warning.limit", Messages.getString("ApplicationHaltsRule_HALTS_WARNING_LIMIT"), Messages.getString("ApplicationHaltsRule_HALTS_WARNING_LIMIT_DESC"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(10L));
    public static final TypedPreference<IQuantity> WINDOW_SIZE = new TypedPreference("app.halts.window.size", Messages.getString("ApplicationHaltsRule_HALTS_WINDOW_SIZE"), Messages.getString("ApplicationHaltsRule_HALTS_WINDOW_SIZE_DESC"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(60L));
    private static final Collection<TypedPreference<?>> CONFIGURATION_ATTRIBUTES = Arrays.asList(APP_HALTS_INFO_LIMIT, APP_HALTS_WARNING_LIMIT, WINDOW_SIZE);
    public static final TypedResult<IRange<IQuantity>> HALTS_WINDOW = new TypedResult("applicationsHaltsWindow", "Halts Window", "The window during which the most application halts were detected.", UnitLookup.TIMERANGE);
    public static final TypedResult<IQuantity> HALTS_RATIO = new TypedResult("applicationHaltsRatio", "Halts Ratio", "The percent of time spent halted.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_HALTS_RATIO = new TypedResult("totalApplicationHaltsRatio", "Halts Ratio", "The percent of time spent halted during the entire recording.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IQuantity> NON_GC_HALTS_RATIO = new TypedResult("nonGcApplicationHaltsRatio", "Non-GC Halts Ratio", "The percent of time spent halted on activities other than garbage collection.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_NON_GC_HALTS_RATIO = new TypedResult("totalNonGcApplicationHaltsRatio", "Non-GC Halts Ratio", "The percent of time spent halted on activities other than garbage collection during the entire recording.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, TOTAL_HALTS_RATIO, TOTAL_NON_GC_HALTS_RATIO, HALTS_RATIO, HALTS_WINDOW, NON_GC_HALTS_RATIO);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GCPhasePause", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.ExecuteVMOperation", RulesToolkit.EventAvailability.ENABLED).build();

    public ApplicationHaltsRule() {
        super("ApplicationHalts", Messages.getString("ApplicationHaltsRule_RULE_NAME"), "java_application", CONFIGURATION_ATTRIBUTES, RESULT_ATTRIBUTES, REQUIRED_EVENTS);
    }

    protected IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        String shortDescription;
        Object[] extraTypes = new String[]{"jdk.SafepointBegin"};
        String extraTypesInfo = null;
        RulesToolkit.EventAvailability extraEventAvailability = RulesToolkit.getEventAvailability((IItemCollection)items, (String[])extraTypes);
        if (extraEventAvailability != RulesToolkit.EventAvailability.AVAILABLE && extraEventAvailability != RulesToolkit.EventAvailability.ENABLED) {
            extraTypesInfo = MessageFormat.format(Messages.getString("ApplicationHaltsRule_EXTRA_EVENT_TYPES"), StringToolkit.join((Object[])extraTypes, (String)", "));
        }
        IQuantity infoLimit = (IQuantity)vp.getPreferenceValue(APP_HALTS_INFO_LIMIT);
        IQuantity warningLimit = (IQuantity)vp.getPreferenceValue(APP_HALTS_WARNING_LIMIT);
        IQuantity windowSize = (IQuantity)vp.getPreferenceValue(WINDOW_SIZE);
        HaltsProvider.ApplicationHaltsInfoHolder haltsRatios = HaltsProvider.calculateApplicationHaltsRatio(items);
        Pair haltsWindowRatio = SlidingWindowToolkit.slidingWindowUnorderedMinMaxValue((IItemCollection)items, (IQuantity)windowSize, (FutureTask)this.evaluationTask, HaltsProvider.applicationHaltsRatioFunction(), ApplicationHaltsRule.applicationHaltsComparator(), (boolean)true, (boolean)true);
        IQuantity haltsTotalWindowRatio = ((HaltsProvider.ApplicationHaltsInfoHolder)haltsWindowRatio.left).getTotalHaltsRatio();
        IQuantity nonGcHaltsToTotalRatio = ((HaltsProvider.ApplicationHaltsInfoHolder)haltsWindowRatio.left).getNonGcHaltsToTotalRatio();
        double score = RulesToolkit.mapExp100((double)haltsTotalWindowRatio.doubleValue(), (double)infoLimit.doubleValue(), (double)warningLimit.doubleValue());
        String longDescription = Messages.getString("ApplicationHaltsRule_RULE_TEXT_LONG");
        if (score >= 25.0) {
            shortDescription = Messages.getString("ApplicationHaltsRule_RULE_TEXT");
            longDescription = longDescription + "\n" + Messages.getString("ApplicationHaltsRule_RULE_TEXT_RECOMMENDATION");
        } else {
            shortDescription = Messages.getString("ApplicationHaltsRule_RULE_TEXT_OK");
        }
        if (extraTypesInfo != null) {
            longDescription = longDescription + "\n" + extraTypesInfo;
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).setSummary(shortDescription).setExplanation(longDescription).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(HALTS_RATIO, (Object)haltsTotalWindowRatio).addResult(HALTS_WINDOW, (Object)((IRange)haltsWindowRatio.right)).addResult(TOTAL_NON_GC_HALTS_RATIO, (Object)haltsRatios.getNonGcHaltsToTotalRatio()).addResult(TOTAL_HALTS_RATIO, (Object)haltsRatios.getTotalHaltsRatio()).addResult(NON_GC_HALTS_RATIO, (Object)nonGcHaltsToTotalRatio).build();
    }

    private static Comparator<HaltsProvider.ApplicationHaltsInfoHolder> applicationHaltsComparator() {
        return new Comparator<HaltsProvider.ApplicationHaltsInfoHolder>(){

            @Override
            public int compare(HaltsProvider.ApplicationHaltsInfoHolder o1, HaltsProvider.ApplicationHaltsInfoHolder o2) {
                return o1.getTotalHaltsRatio().compareTo((Object)o2.getTotalHaltsRatio());
            }
        };
    }
}

