/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class ManagementAgentRule
implements IRule {
    private static final String RESULT_ID = "ManagementAgent";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.InitialSystemProperty", RulesToolkit.EventAvailability.AVAILABLE).build();

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IItemCollection properties = items.apply(JdkFilters.SYSTEM_PROPERTIES);
        Set portStr = (Set)properties.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.ENVIRONMENT_KEY, (Object)"com.sun.management.jmxremote.port")).getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.ENVIRONMENT_VALUE));
        Set authStr = (Set)properties.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.ENVIRONMENT_KEY, (Object)"com.sun.management.jmxremote.authenticate")).getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.ENVIRONMENT_VALUE));
        Set sslStr = (Set)properties.apply(ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.ENVIRONMENT_KEY, (Object)"com.sun.management.jmxremote.ssl")).getAggregate(Aggregators.distinct((IAttribute)JdkAttributes.ENVIRONMENT_VALUE));
        if (ManagementAgentRule.size(portStr) > 1 || ManagementAgentRule.size(authStr) > 1 || ManagementAgentRule.size(sslStr) > 1) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.INFO).setSummary(Messages.getString("ManagementAgentRule_TEXT_INFO")).setSummary(Messages.getString("ManagementAgentRule_TEXT_INFO_LONG")).build();
        }
        if (ManagementAgentRule.size(portStr) > 0) {
            boolean ssl;
            boolean auth = ManagementAgentRule.size(authStr) > 0 ? Boolean.parseBoolean((String)authStr.iterator().next()) : true;
            boolean bl = ssl = ManagementAgentRule.size(sslStr) > 0 ? Boolean.parseBoolean((String)sslStr.iterator().next()) : true;
            if (auth || ssl) {
                ResultBuilder builder = ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider);
                if (!auth && !ssl) {
                    builder = builder.setSeverity(Severity.WARNING).setSummary(Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_BOTH_DISABLED")).setExplanation("ManagmentAgentRuleFactory_TEXT_WARN_BOTH_DISABLED_LONG");
                } else if (!auth) {
                    builder = builder.setSeverity(Severity.WARNING).setSummary(Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_AUTH_DISABLED")).setExplanation(Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_AUTH_DISABLED_LONG"));
                } else if (!ssl) {
                    builder = builder.setSeverity(Severity.INFO).setSummary(Messages.getString("ManagmentAgentRuleFactory_TEXT_INFO_SSL_DISABLED")).setExplanation(Messages.getString("ManagmentAgentRuleFactory_TEXT_INFO_SSL_DISABLED_LONG"));
                }
                return builder.setSolution(Messages.getString("ManagmentAgentRuleFactory_TEXT_WARN_CONFIGURE_GUIDE")).build();
            }
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("ManagmentAgentRuleFactory_TEXT_OK")).build();
    }

    private static int size(Collection<?> set) {
        return set == null ? 0 : set.size();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return ManagementAgentRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("ManagmentAgentRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return Collections.emptyList();
    }
}

