/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.combine;

import org.openjdk.jmc.flightrecorder.rules.jdk.combine.Combinable;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.Combiner;

public class SpanLimit
implements Combinable<SpanLimit> {
    public final long start;
    public final long end;
    public final double value;
    public final double limit;

    public SpanLimit(long start, long end, double mass, double limit) {
        this.start = start;
        this.end = end;
        this.value = mass;
        this.limit = limit;
    }

    @Override
    public SpanLimit combineWith(SpanLimit other) {
        double combinedMass = (this.value + other.value) / 2.0;
        return combinedMass > this.limit ? new SpanLimit(this.start, other.end, combinedMass, this.limit) : null;
    }

    public static SpanLimit getMaxSpan(SpanLimit[] clusters) {
        SpanLimit maxSpan = null;
        int clusterCount = Combiner.combine((Combinable[])clusters);
        for (int j = 0; j < clusterCount; ++j) {
            if (maxSpan != null && maxSpan.end - maxSpan.start >= clusters[j].end - clusters[j].start) continue;
            maxSpan = clusters[j];
        }
        return maxSpan;
    }

    public static SpanLimit getMaxValue(SpanLimit[] clusters) {
        SpanLimit maxValue = null;
        int clusterCount = Combiner.combine((Combinable[])clusters);
        for (int j = 0; j < clusterCount; ++j) {
            if (maxValue != null && !(maxValue.value < clusters[j].value)) continue;
            maxValue = clusters[j];
        }
        return maxValue;
    }

    public String toString() {
        return "SpanLimit: value: " + this.value + ", start " + this.start + ", end " + this.end + ", limit " + this.limit;
    }
}

