/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.latency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCFrame;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCPackage;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.GroupingAggregator;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.QuantityConversionException;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.FormatToolkit;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.MCStackTrace;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.MethodProfilingDataProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class MethodProfilingRule
implements IRule {
    private static final double SAMPLES_PER_PERIOD = 5.0;
    public static final ContentType<MethodProfilingWindowResult> METHOD_PROFILING_WINDOW_RESULT = UnitLookup.createSyntheticContentType((String)"methodProfilingWindowResult");
    public static final TypedResult<IMCMethod> MOST_INTERESTING_METHOD = new TypedResult("mostInterestingMethod", "Most Interesting Method", "The method that, if optimized, would likely have the most impact on CPU usage.", UnitLookup.METHOD, IMCMethod.class);
    public static final TypedResult<IMCStackTrace> MOST_INTERESTING_STACKTRACE = new TypedResult("mostInterestingStackTrace", "Most Interesting Stack Trace", "The most common stack trace amongst the available samples.", UnitLookup.STACKTRACE, IMCStackTrace.class);
    public static final TypedResult<IQuantity> RATIO_OF_ALL_POSSIBLE_SAMPLES = new TypedResult("ratioOfAllPossibleSamples", "Ratio of All Possible Samples", "The ratio between the most interestint methods samples and all possible samples.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IQuantity> RATIO_OF_ACTUAL_SAMPLES = new TypedResult("ratioOfSamples", "Ratio of Samples", "The ratio between the most interestint methods samples and all available samples.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IRange<IQuantity>> MOST_INTERESTING_WINDOW = new TypedResult("mostInterestingWindow", "Most Interesting Time Window", "The time window in which the most interesting samples were found.", UnitLookup.TIMERANGE);
    public static final TypedCollectionResult<MethodProfilingWindowResult> INTERESTING_METHODS = new TypedCollectionResult("interestingMethods", "Interesting Methods", "Methods that, if optimized, would likely have the decent impact on CPU usage.", METHOD_PROFILING_WINDOW_RESULT, MethodProfilingWindowResult.class);
    private static final String RESULT_ID = "MethodProfiling";
    public static final TypedPreference<IQuantity> WINDOW_SIZE = new TypedPreference("method.profiling.evaluation.window.size", Messages.getString("MethodProfilingRule_WINDOW_SIZE"), Messages.getString("MethodProfilingRule_WINDOW_SIZE_DESC"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(30L));
    public static final TypedPreference<String> EXCLUDED_PACKAGE_REGEXP = new TypedPreference("method.profiling.evaluation.excluded.package", Messages.getString("MethodProfilingRule_EXCLUDED_PACKAGES"), Messages.getString("MethodProfilingRule_EXCLUDED_PACKAGES_DESC"), UnitLookup.PLAIN_TEXT.getPersister(), (Object)"java\\.(lang|util)");
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(WINDOW_SIZE, EXCLUDED_PACKAGE_REGEXP);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, MOST_INTERESTING_WINDOW, MOST_INTERESTING_METHOD, MOST_INTERESTING_STACKTRACE, RATIO_OF_ACTUAL_SAMPLES, RATIO_OF_ALL_POSSIBLE_SAMPLES, INTERESTING_METHODS);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ExecutionSample", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.ActiveSetting", RulesToolkit.EventAvailability.AVAILABLE).build();

    public RunnableFuture<IResult> createEvaluation(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        MethodProfilingCallable callable = new MethodProfilingCallable(items, valueProvider, resultProvider);
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(callable);
        callable.setTask(evaluationTask);
        return evaluationTask;
    }

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider, FutureTask<IResult> evaluationTask) {
        Pattern excludes;
        PeriodRangeMap settings = new PeriodRangeMap();
        IItemFilter settingsFilter = RulesToolkit.getSettingsFilter((String)"period", (String[])new String[]{"jdk.ExecutionSample"});
        this.populateSettingsMap(items.apply(settingsFilter), settings);
        IQuantity windowSize = (IQuantity)valueProvider.getPreferenceValue(WINDOW_SIZE);
        ITypedQuantity slideSize = UnitLookup.SECOND.quantity(windowSize.ratioTo((IQuantity)UnitLookup.SECOND.quantity(2L)));
        String excludedPattern = (String)valueProvider.getPreferenceValue(EXCLUDED_PACKAGE_REGEXP);
        try {
            excludes = Pattern.compile(excludedPattern);
        }
        catch (Exception e) {
            excludes = Pattern.compile("");
        }
        ArrayList<MethodProfilingWindowResult> windowResults = new ArrayList<MethodProfilingWindowResult>();
        SlidingWindowToolkit.IUnorderedWindowVisitor visitor = this.createWindowVisitor(settings, settingsFilter, windowSize, windowResults, evaluationTask, excludes);
        SlidingWindowToolkit.slidingWindowUnordered((SlidingWindowToolkit.IUnorderedWindowVisitor)visitor, (IItemCollection)items, (IQuantity)windowSize, (IQuantity)slideSize);
        if (windowResults.isEmpty()) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (IPreferenceValueProvider)valueProvider, (String)Messages.getString("HotMethodsRuleFactory_NOT_ENOUGH_SAMPLES"));
        }
        Pair<MethodProfilingWindowResult, Map<IMCStackTrace, MethodProfilingWindowResult>> interestingMethods = this.getInterestingMethods(windowResults);
        Map percentByMethod = (Map)interestingMethods.right;
        MethodProfilingWindowResult mostInterestingResult = (MethodProfilingWindowResult)interestingMethods.left;
        if (mostInterestingResult == null) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("HotMethodsRuleFactory_TEXT_OK")).build();
        }
        double mappedScore = this.performSigmoidMap(mostInterestingResult.getRatioOfAllPossibleSamples().doubleValueIn((IUnit)UnitLookup.PERCENT_UNITY));
        if (mappedScore < 25.0) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)mappedScore)).setSummary(Messages.getString("HotMethodsRuleFactory_TEXT_OK")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(mappedScore)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)mappedScore)).setSummary(Messages.getString("HotMethodsRuleFactory_TEXT_INFO")).setExplanation(Messages.getString("HotMethodsRuleFactory_TEXT_INFO_LONG")).addResult(MOST_INTERESTING_METHOD, (Object)mostInterestingResult.getMethod()).addResult(MOST_INTERESTING_STACKTRACE, (Object)mostInterestingResult.path).addResult(MOST_INTERESTING_WINDOW, mostInterestingResult.getWindow()).addResult(RATIO_OF_ACTUAL_SAMPLES, (Object)mostInterestingResult.getRatioOfActualSamples()).addResult(RATIO_OF_ALL_POSSIBLE_SAMPLES, (Object)mostInterestingResult.getRatioOfAllPossibleSamples()).addResult(INTERESTING_METHODS, percentByMethod.values()).build();
    }

    private Pair<MethodProfilingWindowResult, Map<IMCStackTrace, MethodProfilingWindowResult>> getInterestingMethods(List<MethodProfilingWindowResult> windowResults) {
        HashMap<IMCStackTrace, MethodProfilingWindowResult> percentByMethod = new HashMap<IMCStackTrace, MethodProfilingWindowResult>();
        ITypedQuantity maxRawScore = UnitLookup.PERCENT_UNITY.quantity(0L);
        MethodProfilingWindowResult mostInterestingResult = null;
        for (MethodProfilingWindowResult result : windowResults) {
            MethodProfilingWindowResult r;
            if (result == null) continue;
            if (result.getRatioOfAllPossibleSamples().compareTo((Object)maxRawScore) > 0) {
                mostInterestingResult = result;
                maxRawScore = result.getRatioOfAllPossibleSamples();
            }
            if (result.getPath() == null || !(this.performSigmoidMap(result.getRatioOfAllPossibleSamples().doubleValueIn((IUnit)UnitLookup.PERCENT_UNITY)) >= 25.0) || (r = (MethodProfilingWindowResult)percentByMethod.get(result.getPath())) != null && result.getRatioOfAllPossibleSamples().compareTo((Object)r.getRatioOfAllPossibleSamples()) <= 0) continue;
            percentByMethod.put(result.getPath(), result);
        }
        return new Pair(mostInterestingResult, percentByMethod);
    }

    private double performSigmoidMap(double input) {
        return RulesToolkit.mapSigmoid((double)input, (double)0.0, (double)100.0, (double)150.0, (double)0.03333, (double)7.0);
    }

    private SlidingWindowToolkit.IUnorderedWindowVisitor createWindowVisitor(final PeriodRangeMap settings, final IItemFilter settingsFilter, final IQuantity windowSize, final List<MethodProfilingWindowResult> rawScores, final FutureTask<IResult> evaluationTask, final Pattern excludes) {
        return new SlidingWindowToolkit.IUnorderedWindowVisitor(){

            /*
             * WARNING - void declaration
             */
            public void visitWindow(IItemCollection items, IQuantity startTime, IQuantity endTime) {
                IRange windowRange = QuantityRange.createWithEnd((IQuantity)startTime, (IQuantity)endTime);
                if (RulesToolkit.getSettingMaxPeriod((IItemCollection)items, (String[])new String[]{"jdk.ExecutionSample"}) == null) {
                    Pair<Pair<IQuantity, IQuantity>, IMCStackTrace> resultPair = this.performCalculation(items, settings.getSetting(startTime));
                    if (resultPair != null) {
                        rawScores.add(new MethodProfilingWindowResult(((IMCFrame)((IMCStackTrace)resultPair.right).getFrames().get(0)).getMethod(), (IMCStackTrace)resultPair.right, (IQuantity)((Pair)resultPair.left).left, (IQuantity)((Pair)resultPair.left).right, (IRange<IQuantity>)windowRange));
                    }
                } else {
                    void var10_15;
                    Set settingTimes = (Set)items.apply(settingsFilter).getAggregate(Aggregators.distinct((IAttribute)JfrAttributes.START_TIME));
                    Object start = startTime;
                    ArrayList<Pair<Pair<IQuantity, IQuantity>, IMCStackTrace>> scores = new ArrayList<Pair<Pair<IQuantity, IQuantity>, IMCStackTrace>>(settingTimes.size());
                    for (Object settingTime : settingTimes) {
                        IItemFilter iItemFilter = ItemFilters.interval((ICanonicalAccessorFactory)JfrAttributes.END_TIME, (Comparable)start, (boolean)true, (Comparable)settingTime, (boolean)true);
                        scores.add(this.performCalculation(items.apply(iItemFilter), settings.getSetting((IQuantity)start)));
                        start = settingTime;
                    }
                    HashMap<IMCStackTrace, Pair> scoresByMethod = new HashMap<IMCStackTrace, Pair>();
                    for (Pair pair : scores) {
                        if (pair == null) continue;
                        if (scoresByMethod.get(pair.right) == null) {
                            scoresByMethod.put((IMCStackTrace)pair.right, (Pair)pair.left);
                            continue;
                        }
                        scoresByMethod.put((IMCStackTrace)pair.right, new Pair((Object)((IQuantity)((Pair)pair.left).left).add((IQuantity)((Pair)scoresByMethod.get((Object)pair.right)).left), (Object)((IQuantity)((Pair)pair.left).right).add((IQuantity)((Pair)scoresByMethod.get((Object)pair.right)).right)));
                    }
                    ITypedQuantity sumScore = UnitLookup.PERCENT_UNITY.quantity(0L);
                    ITypedQuantity iTypedQuantity = UnitLookup.PERCENT_UNITY.quantity(0L);
                    IMCStackTrace hottestPath = null;
                    for (Map.Entry entry : scoresByMethod.entrySet()) {
                        if (((IQuantity)((Pair)entry.getValue()).left).compareTo((Object)sumScore) <= 0) continue;
                        hottestPath = (IMCStackTrace)entry.getKey();
                        IQuantity iQuantity = (IQuantity)((Pair)entry.getValue()).right;
                        sumScore = sumScore.add((IQuantity)((Pair)entry.getValue()).left);
                    }
                    IQuantity averageOfAllPossibleSamples = sumScore.multiply(1.0 / (double)scores.size());
                    IMCMethod hottestMethod = hottestPath == null ? null : ((IMCFrame)hottestPath.getFrames().get(0)).getMethod();
                    rawScores.add(new MethodProfilingWindowResult(hottestMethod, hottestPath, averageOfAllPossibleSamples, (IQuantity)var10_15, (IRange<IQuantity>)windowRange));
                }
            }

            public boolean shouldContinue() {
                return evaluationTask != null && !evaluationTask.isCancelled();
            }

            private Pair<Pair<IQuantity, IQuantity>, IMCStackTrace> performCalculation(IItemCollection items, IQuantity period) {
                IItemCollection filteredItems = items.apply(JdkFilters.EXECUTION_SAMPLE);
                final IMCMethod[] maxMethod = new IMCMethod[1];
                final IMCStackTrace[] maxPath = new IMCStackTrace[1];
                IAggregator aggregator = GroupingAggregator.build((String)"", (String)"", MethodProfilingDataProvider.PATH_ACCESSOR_FACTORY, (IAggregator)Aggregators.count(), (GroupingAggregator.IGroupsFinisher)new GroupingAggregator.IGroupsFinisher<IQuantity, IMCStackTrace, Aggregators.CountConsumer>(){

                    public IType<IQuantity> getValueType() {
                        return UnitLookup.NUMBER;
                    }

                    public IQuantity getValue(Iterable<? extends GroupingAggregator.GroupEntry<IMCStackTrace, Aggregators.CountConsumer>> groupEntries) {
                        HashMap<IMCMethod, Object> map = new HashMap<IMCMethod, Object>();
                        HashMap<IMCMethod, IMCStackTrace> pathMap = new HashMap<IMCMethod, IMCStackTrace>();
                        int total = 0;
                        for (GroupingAggregator.GroupEntry<IMCStackTrace, Aggregators.CountConsumer> groupEntry : groupEntries) {
                            IMCStackTrace trace = this.processPath((IMCStackTrace)groupEntry.getKey());
                            total += ((Aggregators.CountConsumer)groupEntry.getConsumer()).getCount();
                            if (trace.getFrames().isEmpty()) continue;
                            IMCMethod topFrameMethod = ((IMCFrame)trace.getFrames().get(0)).getMethod();
                            if (map.get(topFrameMethod) == null) {
                                map.put(topFrameMethod, UnitLookup.NUMBER_UNITY.quantity((long)((Aggregators.CountConsumer)groupEntry.getConsumer()).getCount()));
                                pathMap.put(topFrameMethod, trace);
                                continue;
                            }
                            IQuantity old = (IQuantity)map.get(topFrameMethod);
                            map.put(topFrameMethod, old.add((IQuantity)UnitLookup.NUMBER_UNITY.quantity((long)((Aggregators.CountConsumer)groupEntry.getConsumer()).getCount())));
                        }
                        if (!pathMap.isEmpty() && !map.isEmpty()) {
                            Map.Entry<IMCMethod, IQuantity> topEntry = Collections.max(map.entrySet(), new Comparator<Map.Entry<IMCMethod, IQuantity>>(){

                                @Override
                                public int compare(Map.Entry<IMCMethod, IQuantity> arg0, Map.Entry<IMCMethod, IQuantity> arg1) {
                                    return arg0.getValue().compareTo((Object)arg1.getValue());
                                }
                            });
                            maxPath[0] = (IMCStackTrace)pathMap.get(topEntry.getKey());
                            maxMethod[0] = topEntry.getKey();
                            return topEntry.getValue().multiply(1.0 / (double)total);
                        }
                        return UnitLookup.NUMBER_UNITY.quantity(0L);
                    }

                    private IMCStackTrace processPath(IMCStackTrace path) {
                        IMCFrame frame;
                        IMCPackage p;
                        Matcher m;
                        ArrayList frames = new ArrayList(path.getFrames());
                        ArrayList<IMCFrame> framesToDrop = new ArrayList<IMCFrame>();
                        Iterator iterator = frames.iterator();
                        while (iterator.hasNext() && (m = excludes.matcher((p = (frame = (IMCFrame)iterator.next()).getMethod().getType().getPackage()).getName() == null ? "" : p.getName())).matches()) {
                            framesToDrop.add(frame);
                        }
                        frames.removeAll(framesToDrop);
                        return new MCStackTrace(frames, path.getTruncationState());
                    }
                });
                IQuantity maxRatio = (IQuantity)filteredItems.getAggregate(aggregator);
                Pair result = null;
                if (maxMethod[0] != null && maxRatio != null && period != null) {
                    double periodsPerSecond = 1.0 / period.doubleValueIn((IUnit)UnitLookup.SECOND);
                    double maxSamplesPerSecond = 5.0 * periodsPerSecond;
                    double samplesInPeriod = ((IQuantity)items.getAggregate(Aggregators.count((IItemFilter)ItemFilters.type((String)"jdk.ExecutionSample")))).doubleValueIn((IUnit)UnitLookup.NUMBER_UNITY);
                    double maxSamplesInPeriod = maxSamplesPerSecond * windowSize.doubleValueIn((IUnit)UnitLookup.SECOND);
                    double relevancy = samplesInPeriod / maxSamplesInPeriod;
                    double highestRatioOfSamples = maxRatio.doubleValueIn((IUnit)UnitLookup.NUMBER_UNITY);
                    ITypedQuantity percentOfActualSamples = UnitLookup.PERCENT_UNITY.quantity(highestRatioOfSamples);
                    ITypedQuantity percentOfAllPossibleSamples = UnitLookup.PERCENT_UNITY.quantity(highestRatioOfSamples * relevancy);
                    result = new Pair((Object)new Pair((Object)percentOfAllPossibleSamples, (Object)percentOfActualSamples), (Object)maxPath[0]);
                }
                return result;
            }
        };
    }

    private void populateSettingsMap(IItemCollection items, PeriodRangeMap settings) {
        for (IItemIterable itemIterable : items) {
            IMemberAccessor startTimeAccessor = JfrAttributes.START_TIME.getAccessor(itemIterable.getType());
            IMemberAccessor settingValueAccessor = JdkAttributes.REC_SETTING_VALUE.getAccessor(itemIterable.getType());
            for (IItem item : itemIterable) {
                settings.addSetting((IQuantity)startTimeAccessor.getMember((Object)item), this.getValueQuantity((String)settingValueAccessor.getMember((Object)item)));
            }
        }
        settings.sort();
    }

    private IQuantity getValueQuantity(String settingValue) {
        try {
            if ("everyChunk".equals(settingValue)) {
                return null;
            }
            return RulesToolkit.parsePersistedJvmTimespan((String)settingValue);
        }
        catch (QuantityConversionException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("MethodProfilingRule_RULE_NAME");
    }

    public String getTopic() {
        return "method_profiling";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }

    private class MethodProfilingCallable
    implements Callable<IResult> {
        private FutureTask<IResult> evaluationTask = null;
        private final IItemCollection items;
        private final IPreferenceValueProvider valueProvider;
        private final IResultValueProvider resultProvider;

        private MethodProfilingCallable(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
            this.items = items;
            this.valueProvider = valueProvider;
            this.resultProvider = resultProvider;
        }

        @Override
        public IResult call() throws Exception {
            return MethodProfilingRule.this.getResult(this.items, this.valueProvider, this.resultProvider, this.evaluationTask);
        }

        void setTask(FutureTask<IResult> task) {
            this.evaluationTask = task;
        }
    }

    public static class MethodProfilingWindowResult
    implements IDisplayable {
        private final IMCMethod method;
        private final IMCStackTrace path;
        private final IQuantity ratioOfAllPossibleSamples;
        private final IQuantity ratioOfActualSamples;
        private final IRange<IQuantity> window;

        public MethodProfilingWindowResult(IMCMethod method, IMCStackTrace path, IQuantity ratio, IQuantity actualRatio, IRange<IQuantity> window) {
            this.method = method;
            this.path = path;
            this.ratioOfAllPossibleSamples = ratio;
            this.ratioOfActualSamples = actualRatio;
            this.window = window;
        }

        public String displayUsing(String formatHint) {
            return FormatToolkit.getHumanReadable((IMCMethod)this.getMethod(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false) + " (" + this.getRatioOfActualSamples().displayUsing(formatHint) + " of samples) " + this.getWindow().displayUsing(formatHint);
        }

        public IMCMethod getMethod() {
            return this.method;
        }

        public IMCStackTrace getPath() {
            return this.path;
        }

        public IQuantity getRatioOfAllPossibleSamples() {
            return this.ratioOfAllPossibleSamples;
        }

        public IQuantity getRatioOfActualSamples() {
            return this.ratioOfActualSamples;
        }

        public IRange<IQuantity> getWindow() {
            return this.window;
        }
    }

    private static class PeriodRangeMap {
        private List<Pair<IQuantity, IQuantity>> settingPairs = new ArrayList<Pair<IQuantity, IQuantity>>();

        private PeriodRangeMap() {
        }

        void addSetting(IQuantity settingTime, IQuantity setting) {
            this.settingPairs.add((Pair<IQuantity, IQuantity>)new Pair((Object)settingTime, (Object)setting));
        }

        IQuantity getSetting(IQuantity timestamp) {
            for (Pair<IQuantity, IQuantity> settingPair : this.settingPairs) {
                boolean isAfterOrAtSettingTime = ((IQuantity)settingPair.left).compareTo((Object)timestamp) <= 0;
                if (!isAfterOrAtSettingTime) continue;
                return (IQuantity)settingPair.right;
            }
            return null;
        }

        void sort() {
            Collections.sort(this.settingPairs, new Comparator<Pair<IQuantity, IQuantity>>(){

                @Override
                public int compare(Pair<IQuantity, IQuantity> p1, Pair<IQuantity, IQuantity> p2) {
                    return ((IQuantity)p1.left).compareTo((Object)((IQuantity)p2.left));
                }
            });
        }
    }
}

