/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IDisplayable;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.IMemberAccessor;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class StackDepthSettingRule
implements IRule {
    private static final IQuantity DEFAULT_STACK_DEPTH_SETTING = UnitLookup.NUMBER_UNITY.quantity(64L);
    public static final ContentType<StackDepthTruncationData> TRUNCATION_DATA = UnitLookup.createSyntheticContentType((String)"truncationData");
    public static final TypedCollectionResult<StackDepthTruncationData> TRUNCATED_TRACES = new TypedCollectionResult("truncatedTraces", "Truncated Traces", "The types that had truncated stacktraces.", TRUNCATION_DATA, StackDepthTruncationData.class);
    public static final TypedResult<IQuantity> STACK_DEPTH = new TypedResult("stackdepth", "Stackdepth", "The maximum stack depth before the trace is truncated.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> TRUNCATION_RATIO = new TypedResult("truncationRatio", "Truncation Ratio", "The percentage of stacktraces that were truncated.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, TRUNCATED_TRACES, STACK_DEPTH, TRUNCATION_RATIO);
    private static final String STACKDEPTH_SETTING_RESULT_ID = "StackdepthSetting";

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IItemFilter stackTracesFilter = ItemFilters.hasAttribute((ICanonicalAccessorFactory)JfrAttributes.EVENT_STACKTRACE);
        HashMap<String, Long> truncatedTracesByType = new HashMap<String, Long>();
        HashMap<String, Long> tracesByType = new HashMap<String, Long>();
        long truncatedTraces = 0L;
        long totalTraces = 0L;
        for (IItemIterable itemIterable : items.apply(stackTracesFilter)) {
            IMemberAccessor stacktraceAccessor = JfrAttributes.EVENT_STACKTRACE.getAccessor(itemIterable.getType());
            for (IItem item : itemIterable) {
                String typeIdentifier = itemIterable.getType().getName();
                IMCStackTrace stacktrace = (IMCStackTrace)stacktraceAccessor.getMember((Object)item);
                ++totalTraces;
                Long tracesForType = tracesByType.containsKey(typeIdentifier) ? (Long)tracesByType.get(typeIdentifier) : 0L;
                tracesByType.put(typeIdentifier, tracesForType + 1L);
                if (stacktrace == null || !stacktrace.getTruncationState().isTruncated()) continue;
                ++truncatedTraces;
                Long truncatedTracesForType = truncatedTracesByType.containsKey(typeIdentifier) ? (Long)truncatedTracesByType.get(typeIdentifier) : 0L;
                truncatedTracesByType.put(typeIdentifier, truncatedTracesForType + 1L);
            }
        }
        if (totalTraces == 0L) {
            return RulesToolkit.getNotApplicableResult((IRule)this, (IPreferenceValueProvider)valueProvider, (String)Messages.getString("StackdepthSettingRule_TEXT_NA"));
        }
        if (truncatedTraces > 0L) {
            ArrayList typesWithTruncatedTraces = new ArrayList(truncatedTracesByType.keySet());
            Collections.sort(typesWithTruncatedTraces);
            ArrayList<StackDepthTruncationData> truncationData = new ArrayList<StackDepthTruncationData>();
            for (String type : typesWithTruncatedTraces) {
                Long value = (Long)truncatedTracesByType.get(type);
                ITypedQuantity percentTruncated = UnitLookup.PERCENT_UNITY.quantity((double)value.longValue() / (double)((Long)tracesByType.get(type)).longValue());
                truncationData.add(new StackDepthTruncationData(type, (IQuantity)percentTruncated));
            }
            double truncatedTracesRatio = (double)truncatedTraces / (double)totalTraces;
            String stackDepthValue = (String)RulesToolkit.getFlightRecorderOptions((IItemCollection)items).get("stackdepth");
            String explanation = Messages.getString("StackdepthSettingRule_TEXT_INFO_LONG");
            double score = RulesToolkit.mapExp100Y((double)truncatedTracesRatio, (double)0.01, (double)25.0);
            IQuantity stackDepthSetting = stackDepthValue == null ? DEFAULT_STACK_DEPTH_SETTING : UnitLookup.NUMBER_UNITY.quantity(Long.parseLong(stackDepthValue));
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("StackdepthSettingRule_TEXT_INFO")).setExplanation(explanation).addResult(STACK_DEPTH, (Object)stackDepthSetting).addResult(TRUNCATED_TRACES, truncationData).addResult(TRUNCATION_RATIO, (Object)UnitLookup.PERCENT_UNITY.quantity(truncatedTracesRatio)).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("StackdepthSettingRule_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return StackDepthSettingRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return STACKDEPTH_SETTING_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("StackdepthSettingRule_RULE_NAME");
    }

    public String getTopic() {
        return "jvm_information";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return Collections.emptyMap();
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }

    public static class StackDepthTruncationData
    implements IDisplayable {
        private final IQuantity percentTruncated;
        private final String type;

        public StackDepthTruncationData(String type, IQuantity percentTruncated) {
            this.type = type;
            this.percentTruncated = percentTruncated;
        }

        public IQuantity getPercentTruncated() {
            return this.percentTruncated;
        }

        public String getType() {
            return this.type;
        }

        public String displayUsing(String formatHint) {
            return MessageFormat.format(Messages.getString("StackdepthSettingRule_TYPE_LIST_TEMPLATE"), this.type, this.percentTruncated.displayUsing(formatHint));
        }
    }
}

