/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class LowOnPhysicalMemoryRule
implements IRule {
    private static final String RESULT_ID = "LowOnPhysicalMemory";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.PhysicalMemory", RulesToolkit.EventAvailability.ENABLED).build();
    public static final TypedResult<IQuantity> USED_MEMORY_RATIO = new TypedResult("usedMemoryRatio", "Used Memory Ratio", "The percentage of used physical memory.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_MEMORY = new TypedResult("totalMemory", JdkAggregators.MIN_TOTAL_MEMORY, (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> MAX_USED_MEMORY = new TypedResult("maxUsedMemory", JdkAggregators.MAX_USED_MEMORY, (ContentType)UnitLookup.MEMORY, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, USED_MEMORY_RATIO, TOTAL_MEMORY, MAX_USED_MEMORY);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        IQuantity total = (IQuantity)items.getAggregate(JdkAggregators.MIN_TOTAL_MEMORY);
        IQuantity used = (IQuantity)items.getAggregate(JdkAggregators.MAX_USED_MEMORY);
        double safeUsage = 0.85;
        double warningLimit = 0.95;
        double usage = used.ratioTo(total);
        double score = RulesToolkit.mapExp100((double)(usage - safeUsage), (double)0.0, (double)(warningLimit - safeUsage));
        if (score > 0.0) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("LowOnPhysicalMemoryFactory_TEXT_INFO")).setExplanation(Messages.getString("LowOnPhysicalMemoryFactory_TEXT_INFO_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(USED_MEMORY_RATIO, (Object)UnitLookup.PERCENT_UNITY.quantity(usage)).addResult(TOTAL_MEMORY, (Object)total).addResult(MAX_USED_MEMORY, (Object)used).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("LowOnPhysicalMemoryFactory_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return LowOnPhysicalMemoryRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("LowOnPhysicalMemoryFactory_RULE_NAME");
    }

    public String getTopic() {
        return "heap";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

