/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.memory.CollectorType;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class LongGcPauseRule
implements IRule {
    private static final String RESULT_ID = "LongGcPause";
    public static final TypedPreference<IQuantity> GC_PAUSE_INFO_LIMIT = new TypedPreference("gc.pause.info.limit", Messages.getString("LongGcPauseRule_CONFIG_INFO_LIMIT"), Messages.getString("LongGcPauseRule_CONFIG_INFO_LIMIT_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.MILLISECOND.quantity(1000L));
    private static final List<TypedPreference<?>> CONFIG_ATTRIBUTES = Arrays.asList(GC_PAUSE_INFO_LIMIT);
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GCPhasePause", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.GCConfiguration", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.GCHeapConfiguration", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.GCPhasePauseLevel1", RulesToolkit.EventAvailability.ENABLED).build();
    public static final TypedResult<IQuantity> LONGEST_PAUSE = new TypedResult("longestPause", "Longest GC Pause", "The longest detected GC pause.", (ContentType)UnitLookup.TIMESPAN, IQuantity.class);
    public static final TypedResult<IQuantity> LIVE_SET = new TypedResult("liveset", "Liveset", "The detected liveset.", (ContentType)UnitLookup.MEMORY, IQuantity.class);
    public static final TypedResult<IQuantity> HEAP_SIZE = new TypedResult("heapSize", "Heap Size", "The detected heap size.", (ContentType)UnitLookup.MEMORY, IQuantity.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, LONGEST_PAUSE, LIVE_SET, HEAP_SIZE);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider rp) {
        IQuantity maxPause = (IQuantity)items.getAggregate(JdkAggregators.LONGEST_GC_PAUSE);
        if (maxPause != null) {
            double gcPauseScore = RulesToolkit.mapExp74((double)maxPause.doubleValueIn((IUnit)UnitLookup.MILLISECOND), (double)((IQuantity)vp.getPreferenceValue(GC_PAUSE_INFO_LIMIT)).doubleValueIn((IUnit)UnitLookup.MILLISECOND));
            String longMessage = "";
            IQuantity liveSet = (IQuantity)items.getAggregate(JdkAggregators.AVG_HEAP_USED_AFTER_GC);
            IQuantity maxMx = (IQuantity)items.getAggregate(JdkAggregators.HEAP_CONF_MAX_SIZE);
            if (gcPauseScore >= 25.0) {
                longMessage = LongGcPauseRule.appendMessage(longMessage, LongGcPauseRule.getLivesetMessage(liveSet, maxMx));
                longMessage = LongGcPauseRule.appendMessage(longMessage, LongGcPauseRule.getSemiRefsMessage(items));
                longMessage = LongGcPauseRule.appendMessage(longMessage, LongGcPauseRule.getCollectorMessage(items));
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)gcPauseScore)).setSummary(Messages.getString("LongGcPauseRuleFactory_TEXT_INFO")).setExplanation(longMessage).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(gcPauseScore)).addResult(LIVE_SET, (Object)liveSet).addResult(HEAP_SIZE, (Object)maxMx).addResult(LONGEST_PAUSE, (Object)maxPause).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("LongGcPauseRuleFactory_TEXT_OK")).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return LongGcPauseRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    private static String appendMessage(String message, String newMessage) {
        if (message == null) {
            return newMessage;
        }
        if (newMessage == null) {
            return message;
        }
        return message + " " + newMessage;
    }

    private static String getCollectorMessage(IItemCollection items) {
        CollectorType oldCollectorType = CollectorType.getOldCollectorType(items);
        if (oldCollectorType != CollectorType.G1_OLD) {
            return Messages.getString("LongGcPauseRuleFactory_TEXT_INFO_G1");
        }
        return null;
    }

    private static String getLivesetMessage(IQuantity liveSet, IQuantity maxMx) {
        int live;
        if (liveSet != null && maxMx != null && (live = (int)(liveSet.ratioTo(maxMx) * 100.0)) < 50) {
            return Messages.getString("LongGcPauseRuleFactory_TEXT_INFO_MX");
        }
        return null;
    }

    private static String getSemiRefsMessage(IItemCollection items) {
        IQuantity aggregate = (IQuantity)items.getAggregate(Aggregators.filter((IAggregator)Aggregators.max((String)"jdk.GCPhasePauseLevel1", (IAttribute)JfrAttributes.DURATION), (IItemFilter)ItemFilters.equals((ICanonicalAccessorFactory)JdkAttributes.GC_PHASE_NAME, (Object)"References")));
        if (aggregate == null) {
            return null;
        }
        int max = aggregate.compareTo((Object)UnitLookup.MILLISECOND.quantity(50L));
        if (max >= 50) {
            return Messages.getString("LongGcPauseRuleFactory_TEXT_INFO_REFERENCES");
        }
        return null;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return CONFIG_ATTRIBUTES;
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("LongGcPauseRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "garbage_collection";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

