/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanSquare;
import org.openjdk.jmc.flightrecorder.rules.jdk.combine.SpanToolkit;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;

public class HighGcRule
implements IRule {
    private static final String RESULT_ID = "HighGc";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.GCPhasePause", RulesToolkit.EventAvailability.ENABLED).build();
    public static final TypedResult<IRange<IQuantity>> PAUSE_CLUSTER = new TypedResult("pauseCluster", "Pause Cluster", "The time in which a cluster of pauses was detected.", UnitLookup.TIMERANGE);
    public static final TypedResult<IQuantity> PAUSE_TIME = new TypedResult("pauseTime", "Pause Time Ratio", "The percent of the cluster spent paused.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, PAUSE_CLUSTER, PAUSE_TIME);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        SpanSquare longestGcCluster = HighGcRule.calculateLongestGcCluster(items.apply(JdkFilters.GC_PAUSE));
        if (longestGcCluster != null) {
            long sumPauseNanos = longestGcCluster.mass;
            IRange cluster = QuantityRange.createWithEnd((IQuantity)UnitLookup.EPOCH_NS.quantity(longestGcCluster.start), (IQuantity)UnitLookup.EPOCH_NS.quantity(longestGcCluster.end));
            long durationNanos = longestGcCluster.end - longestGcCluster.start;
            ITypedQuantity pausePercent = UnitLookup.PERCENT_UNITY.quantity((double)sumPauseNanos / (double)durationNanos);
            double score = RulesToolkit.mapExp100Y((double)sumPauseNanos, (double)1.0E9, (double)90.0);
            String longMessage = Messages.getString("HighGcRuleFactory_TEXT_INFO_LONG");
            if (!RulesToolkit.isEventsEnabled((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"})) {
                longMessage = longMessage + "\n" + RulesToolkit.getEnabledEventTypesRecommendation((IItemCollection)items, (String[])new String[]{"jdk.ObjectAllocationInNewTLAB", "jdk.ObjectAllocationOutsideTLAB"});
            }
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("HighGcRuleFactory_TEXT_INFO")).setExplanation(longMessage).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(PAUSE_CLUSTER, (Object)cluster).addResult(PAUSE_TIME, (Object)pausePercent).build();
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.OK).setSummary(Messages.getString("HighGcRuleFactory_TEXT_OK")).build();
    }

    private static SpanSquare calculateLongestGcCluster(IItemCollection items) {
        return SpanToolkit.getMaxDurationCluster(items);
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return HighGcRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return RESULT_ID;
    }

    public String getName() {
        return Messages.getString("HighGcRuleFactory_RULE_NAME");
    }

    public String getTopic() {
        return "heap";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

