/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.memory;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;
import org.openjdk.jmc.common.IMCMethod;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.collection.MapToolkit;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.ICanonicalAccessorFactory;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedCollectionResult;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.dataproviders.StacktraceDataProvider;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.StacktraceModel;

public class AllocationByThreadRule
implements IRule {
    private static final String THREAD_RESULT_ID = "Allocations.thread";
    private static final Map<String, RulesToolkit.EventAvailability> REQUIRED_EVENTS = RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ObjectAllocationInNewTLAB", RulesToolkit.EventAvailability.ENABLED).addEventType("jdk.ObjectAllocationOutsideTLAB", RulesToolkit.EventAvailability.ENABLED).build();
    public static final TypedResult<IMCThread> MOST_ALLOCATING_THREAD = new TypedResult("mostAllocatingThread", "Most Allocating Thread", "The thread that allocated the most.", UnitLookup.THREAD, IMCThread.class);
    public static final TypedCollectionResult<IMCMethod> ALLOCATION_FRAMES = new TypedCollectionResult("allocationFrames", "Allocation Frames", "The most interesting frames leading to the most commonly allocated type.", UnitLookup.METHOD, IMCMethod.class);
    private static final Collection<TypedResult<?>> RESULT_ATTRIBUTES = Arrays.asList(TypedResult.SCORE, MOST_ALLOCATING_THREAD, ALLOCATION_FRAMES);

    private IResult getResult(IItemCollection items, IPreferenceValueProvider valueProvider, IResultValueProvider resultProvider) {
        List entries = RulesToolkit.calculateGroupingScore((IItemCollection)items.apply(JdkFilters.ALLOC_ALL), (IAccessorFactory)JfrAttributes.EVENT_THREAD);
        if (entries.size() > 0) {
            double balance = RulesToolkit.calculateBalanceScore((List)entries);
            MapToolkit.IntEntry mostSignificant = (MapToolkit.IntEntry)entries.get(entries.size() - 1);
            double relevance = RulesToolkit.mapExp100Y((double)mostSignificant.getValue(), (double)1000.0, (double)50.0);
            double score = balance * relevance * 0.74;
            IItemFilter significantFilter = ItemFilters.and((IItemFilter[])new IItemFilter[]{JdkFilters.ALLOC_ALL, ItemFilters.equals((ICanonicalAccessorFactory)JfrAttributes.EVENT_THREAD, (Object)mostSignificant.getKey())});
            StacktraceModel stacktraceModel = new StacktraceModel(false, new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false), items.apply(significantFilter));
            StacktraceModel.Fork rootFork = stacktraceModel.getRootFork();
            if (rootFork.getBranchCount() > 0) {
                List<IMCMethod> mostRelevantFrames = StacktraceDataProvider.getRelevantTraceList(rootFork.getBranch(0), rootFork.getItemsInFork());
                return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.get((double)score)).setSummary(Messages.getString("AllocationByThreadRule_TEXT_MESSAGE")).setExplanation(Messages.getString("AllocationRuleFactory_TEXT_THREAD_INFO_LONG")).addResult(TypedResult.SCORE, (Object)UnitLookup.NUMBER_UNITY.quantity(score)).addResult(MOST_ALLOCATING_THREAD, mostSignificant.getKey()).addResult(ALLOCATION_FRAMES, mostRelevantFrames).build();
            }
        }
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)valueProvider).setSeverity(Severity.NA).build();
    }

    public RunnableFuture<IResult> createEvaluation(final IItemCollection items, final IPreferenceValueProvider valueProvider, final IResultValueProvider resultProvider) {
        FutureTask<IResult> evaluationTask = new FutureTask<IResult>(new Callable<IResult>(){

            @Override
            public IResult call() throws Exception {
                return AllocationByThreadRule.this.getResult(items, valueProvider, resultProvider);
            }
        });
        return evaluationTask;
    }

    public Collection<TypedPreference<?>> getConfigurationAttributes() {
        return Collections.emptyList();
    }

    public String getId() {
        return THREAD_RESULT_ID;
    }

    public String getName() {
        return Messages.getString("AllocationByThreadRule_RULE_NAME");
    }

    public String getTopic() {
        return "java_application";
    }

    public Map<String, RulesToolkit.EventAvailability> getRequiredEvents() {
        return REQUIRED_EVENTS;
    }

    public Collection<TypedResult<?>> getResults() {
        return RESULT_ATTRIBUTES;
    }
}

