/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.rules.jdk.general;

import java.util.Arrays;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.GroupingAggregator;
import org.openjdk.jmc.common.item.IAccessorFactory;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItem;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemConsumerFactory;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IType;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.IPersister;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.IPreferenceValueProvider;
import org.openjdk.jmc.common.util.Pair;
import org.openjdk.jmc.common.util.TypedPreference;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkAggregators;
import org.openjdk.jmc.flightrecorder.jdk.JdkAttributes;
import org.openjdk.jmc.flightrecorder.jdk.JdkFilters;
import org.openjdk.jmc.flightrecorder.rules.AbstractRule;
import org.openjdk.jmc.flightrecorder.rules.IResult;
import org.openjdk.jmc.flightrecorder.rules.IResultValueProvider;
import org.openjdk.jmc.flightrecorder.rules.IRule;
import org.openjdk.jmc.flightrecorder.rules.ResultBuilder;
import org.openjdk.jmc.flightrecorder.rules.Severity;
import org.openjdk.jmc.flightrecorder.rules.TypedResult;
import org.openjdk.jmc.flightrecorder.rules.jdk.RulePreferences;
import org.openjdk.jmc.flightrecorder.rules.jdk.messages.internal.Messages;
import org.openjdk.jmc.flightrecorder.rules.util.RulesToolkit;
import org.openjdk.jmc.flightrecorder.rules.util.SlidingWindowToolkit;

public class FewSampledThreadsRule
extends AbstractRule {
    private static final IAggregator<Iterable<? extends GroupingAggregator.GroupEntry<IMCThread, Aggregators.CountConsumer>>, ?> SAMPLES_PER_THREAD = GroupingAggregator.build((String)Messages.getString("FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD"), (String)Messages.getString("FewSampledThreadsRule_AGGR_SAMPLES_PER_THREAD_DESC"), (IAccessorFactory)JfrAttributes.EVENT_THREAD, (IItemConsumerFactory)Aggregators.count(), (Predicate)new Predicate<IType<IItem>>(){

        @Override
        public boolean test(IType<IItem> type) {
            return type.getIdentifier().equals("jdk.ExecutionSample");
        }
    });
    public static final TypedPreference<IQuantity> SAMPLED_THREADS_RATIO_LIMIT = new TypedPreference("sampled.threads.ratio.limit", Messages.getString("FewSampledThreadsRule_SAMPLED_THREADS_RATIO_WARNING_LIMIT"), Messages.getString("FewSampledThreadsRule_SAMPLED_THREADS_RATIO_WARNING_LIMIT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(0.25));
    public static final TypedPreference<IQuantity> MIN_CPU_RATIO_LIMIT = new TypedPreference("min.cpu.per.core.limit", Messages.getString("FewSampledThreadsRule_MIN_CPU_RATIO"), Messages.getString("FewSampledThreadsRule_MIN_CPU_RATIO_LONG"), (IPersister)UnitLookup.PERCENTAGE, (Object)UnitLookup.PERCENT.quantity(10L));
    public static final TypedPreference<IQuantity> CPU_WINDOW_SIZE = new TypedPreference("cpu.window.size", Messages.getString("FewSampledThreadsRule_CPU_WINDOW_SIZE"), Messages.getString("FewSampledThreadsRule_CPU_WINDOW_SIZE_LONG"), (IPersister)UnitLookup.TIMESPAN, (Object)UnitLookup.SECOND.quantity(10L));
    public static final TypedPreference<IQuantity> MIN_SAMPLE_COUNT = new TypedPreference("min.sample.count", Messages.getString("FewSampledThreadsRule_MIN_SAMPLE_COUNT"), Messages.getString("FewSampledThreadsRule_MIN_SAMPLE_COUNT_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(20L));
    public static final TypedPreference<IQuantity> MIN_SAMPLE_COUNT_PER_THREAD = new TypedPreference("min.sample.count.per.thread", Messages.getString("FewSampledThreadsRule_MIN_SAMPLE_COUNT_PER_THREAD"), Messages.getString("FewSampledThreadsRule_MIN_SAMPLE_COUNT_PER_THREAD_LONG"), (IPersister)UnitLookup.NUMBER, (Object)UnitLookup.NUMBER_UNITY.quantity(4L));
    public static final TypedResult<IQuantity> HW_THREADS = new TypedResult("hwThreads", "Hardware Threads", "The number of hardware threads available.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IQuantity> THREADS_WITH_ENOUGH_SAMPLES = new TypedResult("threadsWithEnoughSamples", "Threads With Enough Samples", "The number of threads that had enough samples.", (ContentType)UnitLookup.NUMBER, IQuantity.class);
    public static final TypedResult<IRange<IQuantity>> MAX_WINDOW = new TypedResult("maxWindow", "Max Window", "The window where the maximum JVM CPU usage was detected.", UnitLookup.TIMERANGE);
    public static final TypedResult<IQuantity> JVM_USAGE = new TypedResult("jvmUsage", "JVM CPU Usage", "The amount of CPU used by the JVM.", (ContentType)UnitLookup.PERCENTAGE, IQuantity.class);
    public static final TypedResult<IQuantity> TOTAL_SAMPLES = new TypedResult("totalSamples", "Total Samples", "The total number of execution samples.", (ContentType)UnitLookup.NUMBER, IQuantity.class);

    public FewSampledThreadsRule() {
        super("FewSampledThreads", Messages.getString("FewSampledThreadsRule_RULE_NAME"), "java_application", Arrays.asList(SAMPLED_THREADS_RATIO_LIMIT, MIN_CPU_RATIO_LIMIT, RulePreferences.SHORT_RECORDING_LIMIT, CPU_WINDOW_SIZE, MIN_SAMPLE_COUNT, MIN_SAMPLE_COUNT_PER_THREAD), Arrays.asList(TypedResult.SCORE, HW_THREADS, THREADS_WITH_ENOUGH_SAMPLES, MAX_WINDOW, JVM_USAGE), RulesToolkit.RequiredEventsBuilder.create().addEventType("jdk.ActiveSetting", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.ExecutionSample", RulesToolkit.EventAvailability.AVAILABLE).addEventType("jdk.CPUInformation", RulesToolkit.EventAvailability.AVAILABLE).build());
    }

    protected IResult getResult(IItemCollection items, IPreferenceValueProvider vp, IResultValueProvider resultProvider) {
        double sampledThreadRatioLimit = ((IQuantity)vp.getPreferenceValue(SAMPLED_THREADS_RATIO_LIMIT)).doubleValueIn((IUnit)UnitLookup.NUMBER_UNITY);
        IQuantity minCpuRatio = (IQuantity)vp.getPreferenceValue(MIN_CPU_RATIO_LIMIT);
        IQuantity windowSize = (IQuantity)vp.getPreferenceValue(CPU_WINDOW_SIZE);
        IQuantity minSampleCountPerThread = (IQuantity)vp.getPreferenceValue(MIN_SAMPLE_COUNT_PER_THREAD);
        IQuantity minSampleCount = (IQuantity)vp.getPreferenceValue(MIN_SAMPLE_COUNT);
        Iterable samplesPerThread = (Iterable)items.getAggregate(SAMPLES_PER_THREAD);
        int threadsWithEnoughSamples = 0;
        int sampledThreads = 0;
        for (GroupingAggregator.GroupEntry ge : samplesPerThread) {
            ++sampledThreads;
            if (!((double)((Aggregators.CountConsumer)ge.getConsumer()).getCount() >= minSampleCountPerThread.doubleValue())) continue;
            ++threadsWithEnoughSamples;
        }
        IResult idleResult = this.getIdleResult(items, minCpuRatio, windowSize, sampledThreads, vp);
        if (idleResult != null) {
            return idleResult;
        }
        IQuantity totalNumberOfSamples = (IQuantity)items.getAggregate(Aggregators.count((IItemFilter)ItemFilters.type((String)"jdk.ExecutionSample")));
        if (totalNumberOfSamples.compareTo((Object)minSampleCount) < 0) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.NA).addResult(TOTAL_SAMPLES, (Object)totalNumberOfSamples).setSummary(Messages.getString("FewSampledThreadsRule_TEXT_NOT_ENOUGH_SAMPLES")).build();
        }
        IQuantity hwThreads = FewSampledThreadsRule.getHardwareThreads(items);
        if ((long)threadsWithEnoughSamples >= hwThreads.longValue()) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).setSummary(Messages.getString("FewSampledThreadsRule_TEXT_OK")).setExplanation(Messages.getString("FewSampledThreadsRule_TEXT_OK_LONG")).build();
        }
        double sampledThreadRatio = (double)threadsWithEnoughSamples / (double)hwThreads.longValue();
        double score = RulesToolkit.mapExp74((double)(1.0 - sampledThreadRatio), (double)sampledThreadRatioLimit);
        return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.get((double)score)).addResult(THREADS_WITH_ENOUGH_SAMPLES, (Object)UnitLookup.NUMBER_UNITY.quantity((long)threadsWithEnoughSamples)).addResult(HW_THREADS, (Object)hwThreads).setSummary(Messages.getString("FewSampledThreadsRule_TEXT_INFO")).setExplanation(Messages.getString("FewSampledThreadsRule_TEXT_INFO_LONG")).build();
    }

    private IResult getIdleResult(IItemCollection items, IQuantity minCpuRatio, IQuantity windowSize, int sampledThreads, IPreferenceValueProvider vp) {
        IQuantity cores;
        ITypedQuantity maxSingleThreadedCpu;
        ITypedQuantity maxCpuForSampledThreads;
        IQuantity jvmUsage;
        ITypedQuantity cpuRatio;
        IItemCollection cpuItems = FewSampledThreadsRule.getCpuItems(items);
        Pair jvmUsageMaxWindow = SlidingWindowToolkit.slidingWindowUnorderedMinMaxValue((IItemCollection)cpuItems, (IQuantity)windowSize, (FutureTask)this.evaluationTask, (SlidingWindowToolkit.IUnorderedWindowValueFunction)new SlidingWindowToolkit.IUnorderedWindowValueFunction<IQuantity>(){

            public IQuantity getValue(IItemCollection items, IQuantity startTime, IQuantity endTime) {
                return (IQuantity)items.getAggregate(JdkAggregators.AVG_JVM_TOTAL_CPU);
            }
        }, (boolean)true, (boolean)false);
        if (jvmUsageMaxWindow != null && (cpuRatio = UnitLookup.PERCENT.quantity((jvmUsage = (IQuantity)jvmUsageMaxWindow.left).ratioTo((IQuantity)(maxCpuForSampledThreads = UnitLookup.PERCENT.quantity(Math.min(100.0, (maxSingleThreadedCpu = UnitLookup.PERCENT.quantity(100.0 / (cores = (IQuantity)items.apply(ItemFilters.type((String)"jdk.CPUInformation")).getAggregate(Aggregators.max((IAttribute)JdkAttributes.NUMBER_OF_CORES))).doubleValue())).multiply((long)sampledThreads).doubleValue())))) * 100.0)).compareTo((Object)minCpuRatio) < 0) {
            return ResultBuilder.createFor((IRule)this, (IPreferenceValueProvider)vp).setSeverity(Severity.OK).addResult(MAX_WINDOW, jvmUsageMaxWindow.right).addResult(JVM_USAGE, (Object)jvmUsage).setSummary(Messages.getString("FewSampledThreadsRule_APPLICATION_IDLE")).setExplanation(Messages.getString("FewSampledThreadsRule_APPLICATION_IDLE_LONG")).build();
        }
        return null;
    }

    private static IItemCollection getCpuItems(IItemCollection items) {
        return items.apply(JdkFilters.CPU_LOAD);
    }

    private static IQuantity getHardwareThreads(IItemCollection items) {
        return (IQuantity)items.apply(ItemFilters.type((String)"jdk.CPUInformation")).getAggregate(Aggregators.max((IAttribute)JdkAttributes.HW_THREADS));
    }
}

